
/*
 * Copyright (C) 2008 Archie L. Cobbs. All rights reserved.
 */

/**
 * This is the API documentation for the <a href="https://github.com/archiecobbs/hl7lib"><b>hl7lib</b></a> Java library.
 *
 * <p>
 * <b>hl7lib</b> is a small Java library for parsing and manipulating version 2.x HL7 messages.

 * <p>
 * Features include:
 * <ul>
 * <li>Parsing and formatting</li>
 * <li>HL7 lower layer protocol (LLP)</li>
 * <li>Java API for creating, editing, and querying</li>
 * <li>An efficient and semantically equivalent XML encoding</li>
 * </ul>
 *
 * <p>
 * @see <a href="https://github.com/archiecobbs/hl7lib">Project Homepage</a>
 */
package org.dellroad.hl7;
