using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public abstract class Segment {
        #region Private Instance Variables
        private Field _SegmentTypeID = new Field();
        private List<Field> _AdditionalFields = new List<Field>();
        private Field _LastFieldToOutput = null;//Incase a lab/whatever has a lower version of HL7, and doesn't want any of the new fields.
        private string _SegmentTerminator = Environment.NewLine;
        #endregion
        #region Public Instance Properties
        public Field SegmentTypeID {
            get {
                return _SegmentTypeID;
            }
            protected set {
                _SegmentTypeID = value;
            }
        }
        public List<Field> AdditionalFields {
            get {
                return _AdditionalFields;
            }
            protected set {
                _AdditionalFields = value;
            }
        }
        public Field LastFieldToOutput {
            get { return _LastFieldToOutput; }
            set { _LastFieldToOutput = value; }
        }
        public string SegmentTerminator {
            get { return _SegmentTerminator; }
            set { _SegmentTerminator = value; }
        }
        public List<Field> AllFields {
            get {
                List<Field> allFields = new List<Field>();
                allFields.AddRange(AdditionalFields);
                allFields.AddRange(KnownFields);
                return allFields;
            }
        }
        public abstract List<Field> KnownFields {
            get;
        }
        public string AllFieldsHL7String {
            get {
                StringBuilder builder = new StringBuilder();
                string lastUsedDelimiter = string.Empty;
                foreach (Field commonOrder in this.AllFields) {
                    builder.Append(commonOrder.RightSideDelimitedValue);
                    lastUsedDelimiter = commonOrder.Delimiter;
                }
                builder = builder.Remove(builder.Length - lastUsedDelimiter.Length, lastUsedDelimiter.Length);
                builder.Append(SegmentTerminator);
                return builder.ToString();
            }
        }
        public string KnownFieldsHL7String {
            get {
                StringBuilder builder = new StringBuilder();
                string lastUsedDelimiter = string.Empty;
                foreach (Field commonOrder in this.KnownFields) {
                    builder.Append(commonOrder.RightSideDelimitedValue);
                    lastUsedDelimiter = commonOrder.Delimiter;
                    if (LastFieldToOutput != null && commonOrder == LastFieldToOutput) { break; }
                }
                builder = builder.Remove(builder.Length - lastUsedDelimiter.Length, lastUsedDelimiter.Length);
                builder.Append(SegmentTerminator);
                return builder.ToString();
            }
        }
        #endregion
        #region Public Class Properties
        public abstract String SegmentType {
            get;
        }
        public abstract String Title {
            get;
        }
        #endregion
    }
}