using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class PlaceOfServiceFacilitySegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _FacilityMnemonic = new Field();
        private Field _FacilityName = new Field();
        private Field _FacilityAddress = new Field();
        private Field _FacilityOtherDesignation = new Field();
        private Field _FacilityCity = new Field();
        private Field _FacilityStateOrProvince = new Field();
        private Field _FacilityZipOrPostalCode = new Field();
        private Field _FacilityPhoneNumber = new Field();
        private Field _FacilityContact = new Field();
        private Field _FacilityDirectorTitle = new Field();
        private Field _FacilityDirectorLastName = new Field();
        private Field _FacilityDirectorFirstName = new Field();
        private Field _FacilityDirectorMiddleInitial = new Field();
        private Field _FacilityDirectorSuffix = new Field();
        private Field _FacilityDirectorPrefix = new Field();
        private Field _FacilityDirectorDegree = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field FacilityMnemonic {
            get {
                return _FacilityMnemonic;
            }
            private set {
                _FacilityMnemonic = value;
            }
        }
        public Field FacilityName {
            get {
                return _FacilityName;
            }
            private set {
                _FacilityName = value;
            }
        }
        public Field FacilityAddress {
            get {
                return _FacilityAddress;
            }
            private set {
                _FacilityAddress = value;
            }
        }
        public Field FacilityOtherDesignation {
            get {
                return _FacilityOtherDesignation;
            }
            private set {
                _FacilityOtherDesignation = value;
            }
        }
        public Field FacilityCity {
            get {
                return _FacilityCity;
            }
            private set {
                _FacilityCity = value;
            }
        }
        public Field FacilityStateOrProvince {
            get {
                return _FacilityStateOrProvince;
            }
            private set {
                _FacilityStateOrProvince = value;
            }
        }
        public Field FacilityZipOrPostalCode {
            get {
                return _FacilityZipOrPostalCode;
            }
            private set {
                _FacilityZipOrPostalCode = value;
            }
        }
        public Field FacilityPhoneNumber {
            get {
                return _FacilityPhoneNumber;
            }
            private set {
                _FacilityPhoneNumber = value;
            }
        }
        public Field FacilityContact {
            get {
                return _FacilityContact;
            }
            private set {
                _FacilityContact = value;
            }
        }
        public Field FacilityDirectorTitle {
            get {
                return _FacilityDirectorTitle;
            }
            private set {
                _FacilityDirectorTitle = value;
            }
        }
        public Field FacilityDirectorLastName {
            get {
                return _FacilityDirectorLastName;
            }
            private set {
                _FacilityDirectorLastName = value;
            }
        }
        public Field FacilityDirectorFirstName {
            get {
                return _FacilityDirectorFirstName;
            }
            private set {
                _FacilityDirectorFirstName = value;
            }
        }
        public Field FacilityDirectorMiddleInitial {
            get {
                return _FacilityDirectorMiddleInitial;
            }
            private set {
                _FacilityDirectorMiddleInitial = value;
            }
        }
        public Field FacilityDirectorSuffix {
            get {
                return _FacilityDirectorSuffix;
            }
            private set {
                _FacilityDirectorSuffix = value;
            }
        }
        public Field FacilityDirectorPrefix {
            get {
                return _FacilityDirectorPrefix;
            }
            private set {
                _FacilityDirectorPrefix = value;
            }
        }
        public Field FacilityDirectorDegree {
            get {
                return _FacilityDirectorDegree;
            }
            private set {
                _FacilityDirectorDegree = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID
                , SequenceNumber
                , FacilityMnemonic
                , FacilityName
                , FacilityAddress
                , FacilityOtherDesignation
                , FacilityCity
                , FacilityStateOrProvince
                , FacilityZipOrPostalCode
                , FacilityPhoneNumber
                , FacilityContact
                , FacilityDirectorTitle
                , FacilityDirectorLastName
                , FacilityDirectorFirstName
                , FacilityDirectorMiddleInitial
                , FacilityDirectorSuffix
                , FacilityDirectorPrefix
                , FacilityDirectorDegree});
            }
        }
        public override string SegmentType {
            get {
                return "ZPS";
            }
        }
        public override string Title {
            get {
                return "Place of Service Facility";
            }
        }
        #endregion
        #region Constructors
        public PlaceOfServiceFacilitySegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ZPS.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.SequenceNumber = new Field("Sequence Number", "ZPS.2", "To identify the number of ZPS segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.FacilityMnemonic = new Field("Facility Mnemonic", "ZPS.3", "Lab code of the lab that performed the testing", RequiredFlags.AlwaysRequired, 5, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            this.FacilityName = new Field("Facility Name", "ZPS.4", "Location that preformed the testing", RequiredFlags.AlwaysRequired, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            this.FacilityAddress = new Field("Facility Address", "ZPS.5", "Informational Purposes", RequiredFlags.AlwaysRequired, 35, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            this.FacilityOtherDesignation = new Field("Facility Other Designation", "ZPS.5", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 0, string.Empty);
            this.FacilityCity = new Field("Facility City", "ZPS.5", "Informational Purposes", RequiredFlags.AlwaysRequired, 16, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityStateOrProvince = new Field("Facility State Or Province", "ZPS.5", "Informational Purposes", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityZipOrPostalCode = new Field("Facility Zip Or Postal Code", "ZPS.5", "Informational Purposes", RequiredFlags.AlwaysRequired, 9, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.FacilityPhoneNumber = new Field("Facility Phone Number", "ZPS.6", "Informational Purposes", RequiredFlags.Optional, 10, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.FacilityContact = new Field("Facility Contact", "ZPS.7", "", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 0, string.Empty);
            this.FacilityDirectorTitle = new Field("Facility Director Title", "ZPS.8", "Informational Purposes", RequiredFlags.Optional, 20, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityDirectorLastName = new Field("Facility Director Last Name", "ZPS.8", "Informational Purposes", RequiredFlags.AlwaysRequired, 20, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityDirectorFirstName = new Field("Facility Director First Name", "ZPS.8", "", RequiredFlags.AlwaysRequired, 20, "Informational Purposes", SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityDirectorMiddleInitial = new Field("Facility Director Middle Initial", "ZPS.8", "", RequiredFlags.Optional, 1, "Informational Purposes", SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.FacilityDirectorSuffix = new Field("Facility Director Suffix", "ZPS.8", "", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 0, string.Empty);
            this.FacilityDirectorPrefix = new Field("Facility Director Prefix", "ZPS.8", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 0, string.Empty);
            this.FacilityDirectorDegree = new Field("Facility Director Degree", "ZPS.8", "Informational Purposes", RequiredFlags.Optional, 20, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
        }
        public PlaceOfServiceFacilitySegment(string message, string fieldDelimiter, string componentDelimiter)
            : this() {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 8) {
                throw new ArgumentException("Not enough fields to construct a valid place of service facility segment (ZPS).  Expected at least 8, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.SequenceNumber.Value = fields[1];
            this.FacilityMnemonic.Value = fields[2];
            this.FacilityName.Value = fields[3];
            if (fields[4].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZPS.5'");
            }
            List<string> components = new List<string>(fields[4].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count != 5) {
                throw new ArgumentException("Unexpected number of components returned from field 'ZPS.4'.  Expected 5, returned " + components.Count);
            }
            this.FacilityAddress.Value = components[0];
            this.FacilityOtherDesignation.Value = components[1];
            this.FacilityCity.Value = components[2];
            this.FacilityStateOrProvince.Value = components[3];
            this.FacilityZipOrPostalCode.Value = components[4];
            //Back to non-nested fields
            this.FacilityPhoneNumber.Value = fields[5];
            this.FacilityContact.Value = fields[6];
            //More nested fields
            if (fields[7].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZPS.8'");
            }
            components = new List<string>(fields[7].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count < 3) {
                throw new ArgumentException("Unexpected number of components returned from field 'ZPS.8'.  Expected at least 3, returned " + components.Count);
            }
            this.FacilityDirectorTitle.Value = components[0];
            this.FacilityDirectorLastName.Value = components[1];
            this.FacilityDirectorFirstName.Value = components[2];
            if (components.Count >= 4) this.FacilityDirectorMiddleInitial.Value = components[3];
            if (components.Count >= 5) this.FacilityDirectorSuffix.Value = components[4];
            if (components.Count >= 6) this.FacilityDirectorPrefix.Value = components[5];
            if (components.Count >= 7) this.FacilityDirectorDegree.Value = components[6];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 8) {
                for (int x = 8; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZPS." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
            //Field Delimiters
            foreach (Field facility in KnownFields) {
                facility.Delimiter = fieldDelimiter;
            }
            //Comonent (nested fields) Delimiters
            foreach (Field facility in new Field[] { FacilityAddress, FacilityOtherDesignation, FacilityCity, FacilityStateOrProvince, FacilityDirectorTitle, FacilityDirectorLastName, FacilityDirectorFirstName, FacilityDirectorMiddleInitial, FacilityDirectorSuffix, FacilityDirectorPrefix }) {
                facility.Delimiter = componentDelimiter;
            }
            //Last field is always a newline
            FacilityDirectorDegree.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
