using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class PatientIdentificationSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _ExternalPatientID = new Field();
        private Field _LabAssignedPatientID = new Field();
        private Field _AlternatePatientID = new Field();
        private Field _PatientLastName = new Field();
        private Field _PatientFirstName = new Field();
        private Field _PatientMiddleInitial = new Field();
        private Field _MothersMaidenName = new Field();
        private Field _PatientDateOfBirth = new Field();
        private Field _PatientAgeYears = new Field();
        private Field _PatientAgeMonths = new Field();
        private Field _PatientAgeDays = new Field();
        private Field _PatientSex = new Field();
        private Field _PatientAlias = new Field();
        private Field _PatientRace = new Field();
        private Field _PatientAddress = new Field();
        private Field _PatientOtherDesignation = new Field();
        private Field _PatientCity = new Field();
        private Field _PatientStateOrProvice = new Field();
        private Field _PatientZipOrPostalCode = new Field();
        private Field _PatientCountryCode = new Field();
        private Field _PatientHomePhoneNumber = new Field();
        private Field _PatientWorkPhoneNumber = new Field();
        private Field _PatientLanguage = new Field();
        private Field _PatientMaritalStatus = new Field();
        private Field _PatientReligion = new Field();
        private Field _CustomerID = new Field();
        private Field _CheckDigit = new Field();
        private Field _CheckDigitScheme = new Field();
        private Field _BillCode = new Field();
        private Field _ABNFlag = new Field();
        private Field _StatusOfSpecimen = new Field();
        private Field _Fasting = new Field();
        private Field _PatientSSNNumber = new Field();
        #endregion
        #region Constructors
        public PatientIdentificationSegment() {   //Creates all the segments but without values. 
            //Might be lab corp specific
            SegmentTypeID = new Field("Segment Type ID", "PID.1", "Used to identify the segment", RequiredFlags.AlwaysRequired, 3, String.Empty, SupportedCharacters.AlphaOnly, 0, "PID");
            SequenceNumber = new Field("Sequence Number", "PID.2", "To identify the number of PID segments contained within the order file", RequiredFlags.AlwaysRequired, 4, String.Empty, SupportedCharacters.NumericOnly, 104, string.Empty);
            ExternalPatientID = new Field("External Patient ID", "PID.3", "Customer assigned patient identifier", RequiredFlags.AlwaysRequired, 20, String.Empty, SupportedCharacters.AlphaNumericSpecial, 105, string.Empty);
            LabAssignedPatientID = new Field("Lab Assigned Patient ID", "PID.4", "Assigned specimen number", RequiredFlags.AlwaysRequired, 11, String.Empty, SupportedCharacters.AlphaNumericSpecial, 106, string.Empty);
            AlternatePatientID = new Field("Alternate Patient ID", "PID.5", "Customer assigned patient identifier", RequiredFlags.Optional, 20, String.Empty, SupportedCharacters.AlphaNumericSpecial, 107, string.Empty);
            PatientLastName = new Field("Patient Last Name", "PID.6", "Patient Demographics", RequiredFlags.AlwaysRequired, 12, String.Empty, SupportedCharacters.AlphaOnly, 108, string.Empty);
            PatientFirstName = new Field("Patient First Name", "PID.6", "Patient Demographics", RequiredFlags.AlwaysRequired, 10, String.Empty, SupportedCharacters.AlphaOnly, 108, string.Empty);
            PatientMiddleInitial = new Field("Patient Middle Initial", "PID.6", "Patient Demographics", RequiredFlags.Optional, 1, String.Empty, SupportedCharacters.AlphaOnly, 108, string.Empty);
            MothersMaidenName = new Field("Mothers Maiden Name", "PID.7", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 109, string.Empty);
            PatientDateOfBirth = new Field("Patient Date of Birth", "PID.8", "Patient Demographics", RequiredFlags.AlwaysRequired, 8, String.Empty, SupportedCharacters.NumericOnly, 110, string.Empty);
            PatientAgeYears = new Field("Patient Age Years", "PID.8", "Patient Demographics", RequiredFlags.Optional, 3, String.Empty, SupportedCharacters.NumericOnly, 110, string.Empty);
            PatientAgeMonths = new Field("Patient Age Months", "PID.8", "Patient Demographics", RequiredFlags.Optional, 2, String.Empty, SupportedCharacters.NumericOnly, 110, string.Empty);
            PatientAgeDays = new Field("Patient Age Days", "PID.8", "Patient Demographics", RequiredFlags.Optional, 2, String.Empty, SupportedCharacters.NumericOnly, 110, string.Empty);
            PatientSex = new Field("Patient Sex", "PID.9", "Patient Demographics", RequiredFlags.Optional, 1, String.Empty, SupportedCharacters.AlphaOnly, 111, string.Empty);
            PatientAlias = new Field("Patient Alias", "PID.10", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 112, string.Empty);
            PatientRace = new Field("Patient Race", "PID.11", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 113, string.Empty);
            PatientAddress = new Field("Patient Address", "PID.12", "Patient Demographics", RequiredFlags.Optional, 35, String.Empty, SupportedCharacters.AlphaNumericSpecial, 114, string.Empty);
            PatientOtherDesignation = new Field("Patient Other Designation", "PID.12", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 114, string.Empty);
            PatientCity = new Field("Patient City", "PID.12", "Patient Demographics", RequiredFlags.Optional, 16, String.Empty, SupportedCharacters.AlphaOnly, 114, string.Empty);
            PatientStateOrProvice = new Field("Patient State or Provice", "PID.12", "Patient Demographics", RequiredFlags.Optional, 2, String.Empty, SupportedCharacters.AlphaOnly, 114, string.Empty);
            PatientZipOrPostalCode = new Field("Patient Zip or PostalCode", "PID.12", "Patient Demographics", RequiredFlags.Optional, 9, String.Empty, SupportedCharacters.NumericOnly, 114, string.Empty);
            PatientCountryCode = new Field("Patient Country Code", "PID.13", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 115, string.Empty);
            PatientHomePhoneNumber = new Field("Patient Home Phone Number", "PID.14", "Patient Demographics", RequiredFlags.Optional, 13, String.Empty, SupportedCharacters.NumericSpecial, 116, string.Empty);
            PatientWorkPhoneNumber = new Field("Patient Work Phone Number", "PID.15", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 117, string.Empty);
            PatientLanguage = new Field("Patient Language", "PID.16", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 118, string.Empty);
            PatientMaritalStatus = new Field("Patient Marital Status", "PID.17", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 119, string.Empty);
            PatientReligion = new Field("Patient Religion", "PID.18", "Patient Demographics", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 120, string.Empty);
            CustomerID = new Field("Customer ID", "PID.19", "Customer Identification", RequiredFlags.AlwaysRequired, 8, String.Empty, SupportedCharacters.NumericOnly, 121, string.Empty);
            CheckDigit = new Field("Check Digit", "PID.19", "Unknown", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 121, string.Empty);
            CheckDigitScheme = new Field("Check Digit Scheme", "PID.19", "Unknown", RequiredFlags.Unused, -1, String.Empty, SupportedCharacters.Unused, 121, string.Empty);
            BillCode = new Field("Bill Code", "PID.19", "Billing Information", RequiredFlags.AlwaysRequired, 2, String.Empty, SupportedCharacters.AlphaNumeric, 121, string.Empty);
            ABNFlag = new Field("ABN Flag", "PID.19", "To determine if patient wavier was signed", RequiredFlags.Optional, 1, String.Empty, SupportedCharacters.AlphaOnly, 121, string.Empty);
            StatusOfSpecimen = new Field("Status of Specimen", "PID.19", "Indication of preliminary or final report", RequiredFlags.AlwaysRequired, 1, String.Empty, SupportedCharacters.AlphaOnly, 121, string.Empty);
            Fasting = new Field("Fasting", "PID.19", "Patient Demographics", RequiredFlags.Optional, 1, String.Empty, SupportedCharacters.AlphaOnly, 121, string.Empty);
            PatientSSNNumber = new Field("Patient SSN Number", "PID.20", "Patient Demographics", RequiredFlags.Optional, 9, String.Empty, SupportedCharacters.NumericOnly, 122, string.Empty);
        }
        public PatientIdentificationSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 1) {
                throw new ArgumentException("Not enough fields to construct a valid patient identification segment (PID).  Expected at least 1, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            if (fields.Count > 1)
                this.SequenceNumber.Value = fields[1];
            if (fields.Count > 2)
                this.ExternalPatientID.Value = fields[2];
            if (fields.Count > 3)
                this.LabAssignedPatientID.Value = fields[3];
            if (fields.Count > 4)
                this.AlternatePatientID.Value = fields[4];
            List<string> components = null;
            if (fields.Count > 5) {
                components = new List<string>(fields[5].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter
                if (components.Count > 0)
                    this.PatientLastName.Value = components[0];
                if (components.Count > 1)
                    this.PatientFirstName.Value = components[1];
                if (components.Count > 2)
                    this.PatientMiddleInitial.Value = components[2];

            }
            //Might not be there
            //Back to non-nested
            if (fields.Count > 6)
                this.MothersMaidenName.Value = fields[6];
            //More nested
            if (fields.Count > 7) {
                components = new List<string>(fields[7].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count > 0)
                    this.PatientDateOfBirth.Value = components[0];
                if (components.Count > 1)
                    this.PatientAgeYears.Value = components[1];
                if (components.Count > 2)
                    this.PatientAgeMonths.Value = components[2];
                if (components.Count > 3)
                    this.PatientAgeDays.Value = components[3];
            }
            if (fields.Count > 8)
                this.PatientSex.Value = fields[8];
            if (fields.Count > 9)
                this.PatientAlias.Value = fields[9];
            if (fields.Count > 10)
                this.PatientRace.Value = fields[10];
            //Another group of nested fields
            if (fields.Count > 11) {
                components = new List<string>(fields[11].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count > 0)
                    this.PatientAddress.Value = components[0];
                if (components.Count > 1)
                    this.PatientOtherDesignation.Value = components[1];
                if (components.Count > 2)
                    this.PatientCity.Value = components[2];
                if (components.Count > 3)
                    this.PatientStateOrProvice.Value = components[3];
                if (components.Count > 4)
                    this.PatientZipOrPostalCode.Value = components[4];
            }
            //Back to non-nested again
            if (fields.Count > 12)
                this.PatientCountryCode.Value = fields[12];
            if (fields.Count > 13)
                this.PatientHomePhoneNumber.Value = fields[13];
            if (fields.Count > 14)
                this.PatientWorkPhoneNumber.Value = fields[14];
            if (fields.Count > 15)
                this.PatientLanguage.Value = fields[15];
            if (fields.Count > 16)
                this.PatientMaritalStatus.Value = fields[16];
            if (fields.Count > 17)
                this.PatientReligion.Value = fields[17];
            //More nested
            //Status of specimen and Fasting is not used in the Order Message (ORM) and ABN flag is optional, why the count is 4 and not 7
            //if (fields[18].Contains(componentDelimiter) == false) {
            //    throw new ArgumentException("Missing component delimiter in field 'PID.19'");
            //}
            if (fields.Count > 18) {
                components = new List<string>(fields[18].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count > 0) { this.CustomerID.Value = components[0]; }
                if (components.Count > 1) { this.CheckDigit.Value = components[1]; }
                if (components.Count > 2) { this.CheckDigitScheme.Value = components[2]; }
                if (components.Count > 3) { this.BillCode.Value = components[3]; }
                if (components.Count > 4) { this.ABNFlag.Value = components[4]; }//Optional in the ORM
                if (components.Count > 5) { this.StatusOfSpecimen.Value = components[5]; }//Not used in the Order Message (ORM), just in the Result Message (ORU)
                if (components.Count > 6) { this.Fasting.Value = components[6]; }//Not used in the Order Message (ORM), just in the Result Message (ORU)
            }
            //Last one non-nested
            //Doesn't have to have the final delimiter if the field isn't included
            if (fields.Count > 19)
                this.PatientSSNNumber.Value = fields[19];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 20) {
                for (int x = 20; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "PID." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public PatientIdentificationSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public PatientIdentificationSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field patientIdentification in KnownFields) {
                patientIdentification.Delimiter = fieldDelimiter;
            }
            //Date of birth/age years/age months/age days should be in here, but not in any example (IE the examples are always just DOB|, not DOB^AM^AY^AD|
            PatientAgeDays.Delimiter = "";
            PatientAgeMonths.Delimiter = "";
            PatientAgeYears.Delimiter = "";
            //Nested field delimiters
            foreach (Field patientIdentification in new Field[] { PatientLastName, PatientFirstName, PatientAddress, PatientOtherDesignation, PatientCity, PatientStateOrProvice, CustomerID, CheckDigit, CheckDigitScheme, BillCode, ABNFlag, StatusOfSpecimen }) {
                patientIdentification.Delimiter = componentDelimiter;
            }
            //last delimiter is always a newline
            this.PatientSSNNumber.Delimiter = System.Environment.NewLine;
        }
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field ExternalPatientID {
            get {
                return _ExternalPatientID;
            }
            private set {
                _ExternalPatientID = value;
            }
        }
        public Field LabAssignedPatientID {
            get {
                return _LabAssignedPatientID;
            }
            private set {
                _LabAssignedPatientID = value;
            }
        }
        public Field AlternatePatientID {
            get {
                return _AlternatePatientID;
            }
            private set {
                _AlternatePatientID = value;
            }
        }
        public Field PatientLastName {
            get {
                return _PatientLastName;
            }
            private set {
                _PatientLastName = value;
            }
        }
        public Field PatientFirstName {
            get {
                return _PatientFirstName;
            }
            private set {
                _PatientFirstName = value;
            }
        }
        public Field PatientMiddleInitial {
            get {
                return _PatientMiddleInitial;
            }
            private set {
                _PatientMiddleInitial = value;
            }
        }
        public Field MothersMaidenName {
            get {
                return _MothersMaidenName;
            }
            private set {
                _MothersMaidenName = value;
            }
        }
        public Field PatientDateOfBirth {
            get {
                return _PatientDateOfBirth;
            }
            private set {
                _PatientDateOfBirth = value;
            }
        }
        public DateTime? TypedPatientDateOfBirth {
            get {
                DateTime result;
                string format = PatientDateOfBirth.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(PatientDateOfBirth.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field PatientAgeYears {
            get {
                return _PatientAgeYears;
            }
            private set {
                _PatientAgeYears = value;
            }
        }
        public Field PatientAgeMonths {
            get {
                return _PatientAgeMonths;
            }
            private set {
                _PatientAgeMonths = value;
            }
        }
        public Field PatientAgeDays {
            get {
                return _PatientAgeDays;
            }
            private set {
                _PatientAgeDays = value;
            }
        }
        public Field PatientSex {
            get {
                return _PatientSex;
            }
            private set {
                _PatientSex = value;
            }
        }
        public Field PatientAlias {
            get {
                return _PatientAlias;
            }
            private set {
                _PatientAlias = value;
            }
        }
        public Field PatientRace {
            get {
                return _PatientRace;
            }
            private set {
                _PatientRace = value;
            }
        }
        public Field PatientAddress {
            get {
                return _PatientAddress;
            }
            private set {
                _PatientAddress = value;
            }
        }
        public Field PatientOtherDesignation {
            get {
                return _PatientOtherDesignation;
            }
            private set {
                _PatientOtherDesignation = value;
            }
        }
        public Field PatientCity {
            get {
                return _PatientCity;
            }
            private set {
                _PatientCity = value;
            }
        }
        public Field PatientStateOrProvice {
            get {
                return _PatientStateOrProvice;
            }
            private set {
                _PatientStateOrProvice = value;
            }
        }
        public Field PatientZipOrPostalCode {
            get {
                return _PatientZipOrPostalCode;
            }
            private set {
                _PatientZipOrPostalCode = value;
            }
        }
        public Field PatientCountryCode {
            get {
                return _PatientCountryCode;
            }
            private set {
                _PatientCountryCode = value;
            }
        }
        public Field PatientHomePhoneNumber {
            get {
                return _PatientHomePhoneNumber;
            }
            private set {
                _PatientHomePhoneNumber = value;
            }
        }
        public Field PatientWorkPhoneNumber {
            get {
                return _PatientWorkPhoneNumber;
            }
            private set {
                _PatientWorkPhoneNumber = value;
            }
        }
        public Field PatientLanguage {
            get {
                return _PatientLanguage;
            }
            private set {
                _PatientLanguage = value;
            }
        }
        public Field PatientMaritalStatus {
            get {
                return _PatientMaritalStatus;
            }
            private set {
                _PatientMaritalStatus = value;
            }
        }
        public Field PatientReligion {
            get {
                return _PatientReligion;
            }
            private set {
                _PatientReligion = value;
            }
        }
        public Field CustomerID {
            get {
                return _CustomerID;
            }
            private set {
                _CustomerID = value;
            }
        }
        public Field CheckDigit {
            get {
                return _CheckDigit;
            }
            private set {
                _CheckDigit = value;
            }
        }
        public Field CheckDigitScheme {
            get {
                return _CheckDigitScheme;
            }
            private set {
                _CheckDigitScheme = value;
            }
        }
        public Field BillCode {
            get {
                return _BillCode;
            }
            private set {
                _BillCode = value;
            }
        }
        public Field ABNFlag {
            get {
                return _ABNFlag;
            }
            private set {
                _ABNFlag = value;
            }
        }
        public Field StatusOfSpecimen {
            get {
                return _StatusOfSpecimen;
            }
            private set {
                _StatusOfSpecimen = value;
            }
        }
        public Field Fasting {
            get {
                return _Fasting;
            }
            private set {
                _Fasting = value;
            }
        }
        public Field PatientSSNNumber {
            get {
                return _PatientSSNNumber;
            }
            private set {
                _PatientSSNNumber = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { this.SegmentTypeID, this.SequenceNumber, this.ExternalPatientID, this.LabAssignedPatientID, this.AlternatePatientID, this.PatientLastName, this.PatientFirstName, this.PatientMiddleInitial, this.MothersMaidenName, this.PatientDateOfBirth, this.PatientAgeYears, this.PatientAgeMonths, this.PatientAgeDays, this.PatientSex, this.PatientAlias, this.PatientRace, this.PatientAddress, this.PatientOtherDesignation, this.PatientCity, this.PatientStateOrProvice, this.PatientZipOrPostalCode, this.PatientCountryCode, this.PatientHomePhoneNumber, this.PatientWorkPhoneNumber, this.PatientLanguage, this.PatientMaritalStatus, this.PatientReligion, this.CustomerID, this.CheckDigit, this.CheckDigitScheme, this.BillCode, this.ABNFlag, this.StatusOfSpecimen, this.Fasting, this.PatientSSNNumber });
            }
        }
        public override string SegmentType {
            get {
                return "PID";
            }
        }
        public override string Title {
            get {
                return "Patient Identification";
            }
        }
        #endregion
    }
}
