using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class PatientGeneralClinicalInformationSegment : Segment {
        #region Private Instance Variables
        private Field _Height = new Field();
        private Field _WeightValue = new Field();
        private Field _WeightUnitOfMeasure = new Field();
        private Field _CollectionValue = new Field();
        private Field _CollectionUnitOfMeasure = new Field();
        private Field _Fasting = new Field();
        #endregion
        #region Public Instance Properties
        public Field Height {
            get {
                return _Height;
            }
            private set {
                _Height = value;
            }
        }
        public Field WeightValue {
            get {
                return _WeightValue;
            }
            private set {
                _WeightValue = value;
            }
        }
        public Field WeightUnitOfMeasure {
            get {
                return _WeightUnitOfMeasure;
            }
            private set {
                _WeightUnitOfMeasure = value;
            }
        }
        public Field CollectionValue {
            get {
                return _CollectionValue;
            }
            private set {
                _CollectionValue = value;
            }
        }
        public Field CollectionUnitOfMeasure {
            get {
                return _CollectionUnitOfMeasure;
            }
            private set {
                _CollectionUnitOfMeasure = value;
            }
        }
        public Field Fasting {
            get {
                return _Fasting;
            }
            private set {
                _Fasting = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, Height, WeightValue, WeightUnitOfMeasure, CollectionValue, CollectionUnitOfMeasure, Fasting });
            }
        }
        public override string SegmentType {
            get {
                return "ZCI";
            }
        }
        public override string Title {
            get {
                return "Patient General Clinical Information";
            }
        }
        #endregion
        #region Constructors
        public PatientGeneralClinicalInformationSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ZCI.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "ZCI");
            this.Height = new Field("Height", "ZCI.2", "Height", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 0, string.Empty);
            this.WeightValue = new Field("Weight Value", "ZCI.3", "In specific testing procedures in calculation of result", RequiredFlags.Conditional, 3, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.WeightUnitOfMeasure = new Field("Weight Unit of Measure", "ZCI.3", "Indication of unit of measure", RequiredFlags.Conditional, 10, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            this.CollectionValue = new Field("Collection Value", "ZCI.4", "In specific testing procedures in calculation of result", RequiredFlags.Conditional, 4, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.CollectionUnitOfMeasure = new Field("Collection Unit of Measure", "ZCI.4", "Indication of unit of measure", RequiredFlags.Conditional, 10, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            this.Fasting = new Field("Fasting", "ZCI.5", "In specific testing procedures in calculation of result", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
        }
        public PatientGeneralClinicalInformationSegment(string message,string fieldDelimiter,string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 5) {
                throw new ArgumentException("Not enough fields to construct a valid patient general clinical information segment (ZCI).  Expected at least 5, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.Height.Value = fields[1];
            if (fields[2].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZCI.3'");
            }
            List<string> components = new List<string>(fields[2].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count != 2) {
                throw new ArgumentException("Unexpected number of components returned for the field 'ZCI.3'.  Expected 2, returned " + components.Count);
            }
            WeightValue.Value = components[0];
            WeightUnitOfMeasure.Value = components[1];
            if (fields[3].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'ZCI.4'");
                CollectionValue.Value = fields[3].Trim();
            } else {
                components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter
                CollectionValue.Value = components.Count > 0 ? components[0] : String.Empty;
                CollectionUnitOfMeasure.Value = components.Count > 1 ? components[1] : String.Empty;
                System.Diagnostics.Debug.WriteLine("Warning - Field 'ZCI.4' returned an execpected number of fields.  Expected 2, returned " + components.Count);
            }
            //Last one non-nested
            this.Fasting.Value = fields[4];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 5) {
                for (int x = 5; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZCI." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public PatientGeneralClinicalInformationSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field patientGeneralClinicalInformation in KnownFields) {
                patientGeneralClinicalInformation.Delimiter = fieldDelimiter;
            }
            foreach (Field patientGeneralClinicalInformation in new Field[] { WeightValue, CollectionValue }) {
                patientGeneralClinicalInformation.Delimiter = componentDelimiter;
            }
            //Last one is always a newline
            this.Fasting.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
