using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class ObservationResultSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _ValueType = new Field();
        private Field _ObservationIdentifier = new Field();
        private Field _ObservationText = new Field();
        private Field _NameOfCodingSystem = new Field();
        private Field _ObservationSubID = new Field();
        private Field _ObservationValue = new Field();
        private Field _UnitOfMeasureIdentifier = new Field();
        private Field _ReferenceRanges = new Field();
        private Field _AbnormalFlags = new Field();
        private Field _Probability = new Field();
        private Field _NatureOfAbnormal = new Field();
        private Field _ObservationResultStatus = new Field();
        private Field _DateOfLastChangeInReferenceRangeOrUnits = new Field();
        private Field _UserDefinedAccessChecks = new Field();
        private Field _DateTimeOfObservation = new Field();
        private Field _ProducerID = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field ValueType {
            get {
                return _ValueType;
            }
            private set {
                _ValueType = value;
            }
        }
        public Field ObservationIdentifier {
            get {
                return _ObservationIdentifier;
            }
            private set {
                _ObservationIdentifier = value;
            }
        }
        public Field ObservationText {
            get {
                return _ObservationText;
            }
            private set {
                _ObservationText = value;
            }
        }
        public Field NameOfCodingSystem {
            get {
                return _NameOfCodingSystem;
            }
            private set {
                _NameOfCodingSystem = value;
            }
        }
        public Field ObservationSubID {
            get {
                return _ObservationSubID;
            }
            private set {
                _ObservationSubID = value;
            }
        }
        public Field ObservationValue {
            get {
                return _ObservationValue;
            }
            private set {
                _ObservationValue = value;
            }
        }
        public Field UnitOfMeasureIdentifier {
            get {
                return _UnitOfMeasureIdentifier;
            }
            private set {
                _UnitOfMeasureIdentifier = value;
            }
        }
        public Field ReferenceRanges {
            get {
                return _ReferenceRanges;
            }
            private set {
                _ReferenceRanges = value;
            }
        }
        public Field AbnormalFlags {
            get {
                return _AbnormalFlags;
            }
            private set {
                _AbnormalFlags = value;
            }
        }
        public Field Probability {
            get {
                return _Probability;
            }
            private set {
                _Probability = value;
            }
        }
        public Field NatureOfAbnormal {
            get {
                return _NatureOfAbnormal;
            }
            private set {
                _NatureOfAbnormal = value;
            }
        }
        public Field ObservationResultStatus {
            get {
                return _ObservationResultStatus;
            }
            private set {
                _ObservationResultStatus = value;
            }
        }
        public Field DateOfLastChangeInReferenceRangeOrUnits {
            get {
                return _DateOfLastChangeInReferenceRangeOrUnits;
            }
            private set {
                _DateOfLastChangeInReferenceRangeOrUnits = value;
            }
        }
        public DateTime? TypedDateOfLastChangeInReferenceRangeOrUnits {
            get {
                DateTime result;
                string format = DateOfLastChangeInReferenceRangeOrUnits.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(DateOfLastChangeInReferenceRangeOrUnits.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field UserDefinedAccessChecks {
            get {
                return _UserDefinedAccessChecks;
            }
            private set {
                _UserDefinedAccessChecks = value;
            }
        }
        public Field DateTimeOfObservation {
            get {
                return _DateTimeOfObservation;
            }
            private set {
                _DateTimeOfObservation = value;
            }
        }
        public DateTime? TypedDateTimeOfObservation {
            get {
                DateTime result;                
                string format = DateTimeOfObservation.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(DateTimeOfObservation.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field ProducerID {
            get {
                return _ProducerID;
            }
            private set {
                _ProducerID = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, ValueType, ObservationIdentifier, ObservationText, NameOfCodingSystem, ObservationSubID, ObservationValue ,
            UnitOfMeasureIdentifier,ReferenceRanges,AbnormalFlags,Probability,NatureOfAbnormal,ObservationResultStatus,DateOfLastChangeInReferenceRangeOrUnits,UserDefinedAccessChecks,DateTimeOfObservation,ProducerID});
            }
        }
        public override string SegmentType {
            get {
                return "OBX";
            }
        }
        public override string Title {
            get {
                return "Observation Result";
            }
        }
        #endregion
        #region Constructors
        public ObservationResultSegment() {
            SegmentTypeID = new Field("Segment Type ID", "OBX.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, SegmentType);
            SequenceNumber = new Field("Sequence Number", "OBX.2", "To identify the number of OBX segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 569, string.Empty);
            ValueType = new Field("Value Type", "OBX.3", "To identify the types of data being sent", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaOnly, 570, string.Empty);
            ObservationIdentifier = new Field("Observation Identifier", "OBX.4", "Test number", RequiredFlags.AlwaysRequired, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 571, string.Empty);
            ObservationText = new Field("Observation Text", "OBX.4", "Test name", RequiredFlags.AlwaysRequired, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 571, string.Empty);
            NameOfCodingSystem = new Field("Name of Coding System", "OBX.4", "Constant Value", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 571, string.Empty);
            ObservationSubID = new Field("Observation Sub-ID", "OBX.5", "To aid in the identification of results with the same observation ID underneath a given OBR", RequiredFlags.Optional, 2, string.Empty, SupportedCharacters.NumericOnly, 572, string.Empty);
            ObservationValue = new Field("Observation Value", "OBX.6", "Re[prted result", RequiredFlags.AlwaysRequired, 28, string.Empty, SupportedCharacters.AlphaNumericSpecial, 573, string.Empty);
            UnitOfMeasureIdentifier = new Field("Unit of Measure Identifier", "OBX.7", "To identify the units of measure", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 574, string.Empty);
            ReferenceRanges = new Field("Reference Ranges", "OBX.8", "To identify the reference ranges for the test performed", RequiredFlags.Conditional, 17, string.Empty, SupportedCharacters.AlphaNumericSpecial, 575, string.Empty);
            AbnormalFlags = new Field("Abnormal Flags", "OBX.9", "To identify if the result is an abnormal value for the test performed", RequiredFlags.Conditional, 2, string.Empty, SupportedCharacters.AlphaOnly, 576, string.Empty);
            Probability = new Field("Probability", "OBX.10", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 577, string.Empty);
            NatureOfAbnormal = new Field("Nature of Abnormal", "OBX.11", "Constant value", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 578, string.Empty);
            ObservationResultStatus = new Field("Observation Result Status", "OBX.12", "Status of result for the test", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 579, string.Empty);
            DateOfLastChangeInReferenceRangeOrUnits = new Field("Date of Last Change in Reference Range or Units", "OBX.13", "Informational purposes", RequiredFlags.Optional, 14, string.Empty, SupportedCharacters.NumericOnly, 580, string.Empty);
            UserDefinedAccessChecks = new Field("User-Defined Access Checks", "OBX.14", "Allows the producer to classify the result for the purpose of controlling user access in the case of sensitive testing", RequiredFlags.Optional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 581, string.Empty);
            DateTimeOfObservation = new Field("Date/Time of Observation", "OBX.15", "Identify the date and time the results were sent", RequiredFlags.Optional, 14, string.Empty, SupportedCharacters.NumericOnly, 582, string.Empty);
            ProducerID = new Field("Producer ID", "OBX.16", "Identification of the facility responsible for performing the testing", RequiredFlags.Conditional, 5, string.Empty, SupportedCharacters.AlphaNumericSpecial, 583, string.Empty);
        }
        public ObservationResultSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 1) {
                throw new ArgumentException("Not enough fields to construct a valid result observation segment (OBX).  Expected at least 1, returned " + fields.Count);
            }
            SegmentTypeID.Value = fields[0];
            if (fields.Count > 1)
                SequenceNumber.Value = fields[1];
            if (fields.Count > 2)
                ValueType.Value = fields[2];
            if (fields.Count > 3)
                if (fields[3].Contains(componentDelimiter)) {
                    List<string> components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                    //A field can have seperate components, essentially nested fields with a differnt delimiter
                    if (components != null) {
                        if (components.Count > 0)
                            ObservationIdentifier.Value = components[0];
                        if (components.Count > 1)
                            ObservationText.Value = components[1];
                        if (components.Count > 2)
                            NameOfCodingSystem.Value = components[2];
                    }
                }
            //Back to non-nested fields
            if (fields.Count > 4)
                ObservationSubID.Value = fields[4];
            if (fields.Count > 5)
                ObservationValue.Value = fields[5];
            if (fields.Count > 6)
                UnitOfMeasureIdentifier.Value = fields[6];
            if (fields.Count > 7)
                ReferenceRanges.Value = fields[7];
            if (fields.Count > 8)
                AbnormalFlags.Value = fields[8];
            if (fields.Count > 9)
                Probability.Value = fields[9];
            if (fields.Count > 10)
                NatureOfAbnormal.Value = fields[10];
            if (fields.Count > 11)
                ObservationResultStatus.Value = fields[11];
            if (fields.Count > 12)
                DateOfLastChangeInReferenceRangeOrUnits.Value = fields[12];
            if (fields.Count > 13)
                UserDefinedAccessChecks.Value = fields[13];
            if (fields.Count > 14)
                DateTimeOfObservation.Value = fields[14];
            if (fields.Count > 15)
                ProducerID.Value = fields[15];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 16) {
                for (int x = 16; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "OBX." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public ObservationResultSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public ObservationResultSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field resultObservation in KnownFields) {
                resultObservation.Delimiter = fieldDelimiter;
            }
            //Nested field delimiters
            foreach (Field resultObservation in new Field[] { ObservationIdentifier, ObservationText }) {
                resultObservation.Delimiter = componentDelimiter;
            }
            //last delimiter is always a newline
            //ProducerID.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
