using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class ObservationOrderSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _UniqueForeignSpecimenID = new Field();
        private Field _ForeignApplicationID = new Field();
        private Field _InternalSpecimenID = new Field();
        private Field _InternalApplicationID = new Field();
        private Field _ObservationBatteryID = new Field();
        private Field _ObservationBatteryText = new Field();
        private Field _NameOfCodingSystem = new Field();
        private Field _Priority = new Field();
        private Field _RequestedDateTime = new Field();
        private Field _ObservationCollectionDateTime = new Field();
        private Field _ObservationCollectionEndDateTime = new Field();
        private Field _CollectionVolume = new Field();
        private Field _CollectorIdentifier = new Field();
        private Field _SpecimenActionCode = new Field();
        private Field _DangerCode = new Field();
        private Field _UnknownField = new Field();
        private Field _RelevantClinicalInformation = new Field();
        private Field _SpecimenReceivedDateTime = new Field();
        private Field _SpecimenSource = new Field();
        private Field _OrderingProvider = new Field();
        private Field _OrderingProviderPhoneNumber = new Field();
        private Field _AlternateUniqueForeignSpecimenID = new Field();
        private Field _RequestorField2 = new Field();
        private Field _ProducerField1 = new Field();
        private Field _ProducerField2 = new Field();
        private Field _DateTimeObservationReported = new Field();
        private Field _ProducerCharge = new Field();
        private Field _ProducerSectionID = new Field();
        private Field _OrderResultStatus = new Field();
        private Field _LinkToParentResult = new Field();
        private Field _QuantityTiming = new Field();
        private Field _ResultCopiesTo = new Field();
        private Field _LinkToParentOrder = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field UniqueForeignSpecimenID {
            get {
                return _UniqueForeignSpecimenID;
            }
            private set {
                _UniqueForeignSpecimenID = value;
            }
        }
        public Field ForeignApplicationID {
            get {
                return _ForeignApplicationID;
            }
            private set {
                _ForeignApplicationID = value;
            }
        }
        public Field InternalSpecimenID {
            get {
                return _InternalSpecimenID;
            }
            private set {
                _InternalSpecimenID = value;
            }
        }
        public Field InternalApplicationID {
            get {
                return _InternalApplicationID;
            }
            private set {
                _InternalApplicationID = value;
            }
        }
        public Field ObservationBatteryID {
            get {
                return _ObservationBatteryID;
            }
            private set {
                _ObservationBatteryID = value;
            }
        }
        public Field ObservationBatteryText {
            get {
                return _ObservationBatteryText;
            }
            private set {
                _ObservationBatteryText = value;
            }
        }
        public Field NameOfCodingSystem {
            get {
                return _NameOfCodingSystem;
            }
            private set {
                _NameOfCodingSystem = value;
            }
        }
        public Field Priority {
            get {
                return _Priority;
            }
            private set {
                _Priority = value;
            }
        }
        public Field RequestedDateTime {
            get {
                return _RequestedDateTime;
            }
            private set {
                _RequestedDateTime = value;
            }
        }
        public DateTime? TypedRequestedDateTime {
            get {
                DateTime result;
                string format = RequestedDateTime.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(RequestedDateTime.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field ObservationCollectionDateTime {
            get {
                return _ObservationCollectionDateTime;
            }
            private set {
                _ObservationCollectionDateTime = value;
            }
        }
        public DateTime? TypedObservationCollectionDateTime {
            get {
                DateTime result;
                string format = ObservationCollectionDateTime.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(ObservationCollectionDateTime.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field ObservationCollectionEndDateTime {
            get {
                return _ObservationCollectionEndDateTime;
            }
            private set {
                _ObservationCollectionEndDateTime = value;
            }
        }
        public DateTime? TypedObservationCollectionEndDateTime {
            get {
                DateTime result;
                string format = ObservationCollectionEndDateTime.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(ObservationCollectionEndDateTime.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field CollectionVolume {
            get {
                return _CollectionVolume;
            }
            private set {
                _CollectionVolume = value;
            }
        }
        public Field CollectorIdentifier {
            get {
                return _CollectorIdentifier;
            }
            private set {
                _CollectorIdentifier = value;
            }
        }
        public Field SpecimenActionCode {
            get {
                return _SpecimenActionCode;
            }
            private set {
                _SpecimenActionCode = value;
            }
        }
        public Field DangerCode {
            get {
                return _DangerCode;
            }
            private set {
                _DangerCode = value;
            }
        }
        public Field UnknownField {
            get {
                return _UnknownField;
            }
            private set {
                _UnknownField = value;
            }
        }
        public Field RelevantClinicalInformation {
            get {
                return _RelevantClinicalInformation;
            }
            private set {
                _RelevantClinicalInformation = value;
            }
        }
        public Field SpecimenReceivedDateTime {
            get {
                return _SpecimenReceivedDateTime;
            }
            private set {
                _SpecimenReceivedDateTime = value;
            }
        }
        public DateTime? TypedSpecimenReceivedDateTime {
            get {
                DateTime result;
                string format = SpecimenReceivedDateTime.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(SpecimenReceivedDateTime.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field SpecimenSource {
            get {
                return _SpecimenSource;
            }
            private set {
                _SpecimenSource = value;
            }
        }
        public Field OrderingProvider {
            get {
                return _OrderingProvider;
            }
            private set {
                _OrderingProvider = value;
            }
        }
        public Field OrderingProviderPhoneNumber {
            get {
                return _OrderingProviderPhoneNumber;
            }
            private set {
                _OrderingProviderPhoneNumber = value;
            }
        }
        public Field AlternateUniqueForeignSpecimenID {
            get {
                return _AlternateUniqueForeignSpecimenID;
            }
            private set {
                _AlternateUniqueForeignSpecimenID = value;
            }
        }
        public Field RequestorField2 {
            get {
                return _RequestorField2;
            }
            private set {
                _RequestorField2 = value;
            }
        }
        public Field ProducerField1 {
            get {
                return _ProducerField1;
            }
            private set {
                _ProducerField1 = value;
            }
        }
        public Field ProducerField2 {
            get {
                return _ProducerField2;
            }
            private set {
                _ProducerField2 = value;
            }
        }
        public Field DateTimeObservationReported {
            get {
                return _DateTimeObservationReported;
            }
            private set {
                _DateTimeObservationReported = value;
            }
        }
        public DateTime? TypedDateTimeObservationReported {
            get {
                DateTime result;
                string format = DateTimeObservationReported.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(DateTimeObservationReported.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field ProducerCharge {
            get {
                return _ProducerCharge;
            }
            private set {
                _ProducerCharge = value;
            }
        }
        public Field ProducerSectionID {
            get {
                return _ProducerSectionID;
            }
            private set {
                _ProducerSectionID = value;
            }
        }
        public Field OrderResultStatus {
            get {
                return _OrderResultStatus;
            }
            private set {
                _OrderResultStatus = value;
            }
        }
        public Field LinkToParentResult {
            get {
                return _LinkToParentResult;
            }
            private set {
                _LinkToParentResult = value;
            }
        }
        public Field QuantityTiming {
            get {
                return _QuantityTiming;
            }
            private set {
                _QuantityTiming = value;
            }
        }
        public Field ResultCopiesTo {
            get {
                return _ResultCopiesTo;
            }
            private set {
                _ResultCopiesTo = value;
            }
        }
        public Field LinkToParentOrder {
            get {
                return _LinkToParentOrder;
            }
            private set {
                _LinkToParentOrder = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, UniqueForeignSpecimenID, ForeignApplicationID, InternalSpecimenID, InternalApplicationID, ObservationBatteryID, ObservationBatteryText, NameOfCodingSystem, Priority, RequestedDateTime, ObservationCollectionDateTime, ObservationCollectionEndDateTime, CollectionVolume, CollectorIdentifier, SpecimenActionCode, DangerCode, RelevantClinicalInformation, SpecimenReceivedDateTime, SpecimenSource, OrderingProvider, OrderingProviderPhoneNumber, AlternateUniqueForeignSpecimenID, RequestorField2, ProducerField1, ProducerField2, DateTimeObservationReported, ProducerCharge, ProducerSectionID, OrderResultStatus, LinkToParentResult, QuantityTiming, ResultCopiesTo, LinkToParentOrder });
            }
        }
        public override string SegmentType {
            get {
                return "OBR";
            }
        }
        public override string Title {
            get {
                return "Observation Order";
            }
        }
        #endregion
        #region Constructors
        public ObservationOrderSegment() {
            SegmentTypeID = new Field("Segment Type ID", "OBR.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "OBR");
            SequenceNumber = new Field("Sequence Number", "OBR.2", "To identify the number of OBR segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 237, string.Empty);
            UniqueForeignSpecimenID = new Field("Unique Foreign Specimen ID", "OBR.3", "Customer specific accessioning or specimen identification number", RequiredFlags.AlwaysRequired, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 216, string.Empty);
            ForeignApplicationID = new Field("Foreign Application ID", "OBR.3", "Constant value", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 217, string.Empty);
            InternalSpecimenID = new Field("Internal Specimen ID", "OBR.4", "Lab assigned specimen number", RequiredFlags.AlwaysRequired, 11, string.Empty, SupportedCharacters.AlphaNumericSpecial, 238, string.Empty);
            InternalApplicationID = new Field("Internal Application ID", "OBR.4", "Constant value", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 238, string.Empty);
            ObservationBatteryID = new Field("Observation Battery ID", "OBR.5", "Test number ordered", RequiredFlags.AlwaysRequired, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 238, string.Empty);
            ObservationBatteryText = new Field("Observation Battery Text", "OBR.5", "Name of test ordered", RequiredFlags.AlwaysRequired, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 238, string.Empty);
            NameOfCodingSystem = new Field("Name of Coding System", "OBR.5", "Constant value", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 238, string.Empty);
            Priority = new Field("Priority", "OBR.6", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 239, string.Empty);
            RequestedDateTime = new Field("Requested Date Time", "OBR.7", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 240, string.Empty);
            ObservationCollectionDateTime = new Field("Observation Collection Date Time", "OBR.8", "Record of the data and time the specimen was collected", RequiredFlags.Optional, 12, string.Empty, SupportedCharacters.NumericOnly, 241, string.Empty);
            ObservationCollectionEndDateTime = new Field("Observation Collection End Date Time", "OBR.9", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 242, string.Empty);
            CollectionVolume = new Field("Collection Volume", "OBR.10", "Amount of specimen collected", RequiredFlags.Conditional, 4, string.Empty, SupportedCharacters.NumericOnly, 243, string.Empty);
            CollectorIdentifier = new Field("Collector Identifier", "OBR.11", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 244, string.Empty);
            SpecimenActionCode = new Field("Specimen Action Code", "OBR.12", "To identify the type of result being returned", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.AlphaOnly, 245, string.Empty);
            DangerCode = new Field("Danger Code", "OBR.13", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 246, string.Empty);
            UnknownField = new Field("Unknown Field", "OBR.14", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 247, string.Empty);
            RelevantClinicalInformation = new Field("Relevant Clinical Information", "OBR.14", "Informational Purposes", RequiredFlags.Conditional, 65, string.Empty, SupportedCharacters.AlphaNumericSpecial, 247, string.Empty);
            SpecimenReceivedDateTime = new Field("Specimen Received Date Time", "OBR.15", "Identify the order entry date and time", RequiredFlags.Optional, 14, string.Empty, SupportedCharacters.NumericOnly, 248, string.Empty);
            SpecimenSource = new Field("Specimen Source", "OBR.16", "Identifies the source of the specimen", RequiredFlags.Optional, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 249, string.Empty);
            OrderingProvider = new Field("Ordering Provider", "OBR.17", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 226, string.Empty);
            OrderingProviderPhoneNumber = new Field("Ordering Provider Phone Number", "OBR.18", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 250, string.Empty);
            AlternateUniqueForeignSpecimenID = new Field("Alternate Unique Foreign Specimen ID", "OBR.19", "Alternate customer specific accessioning or specimen identification number", RequiredFlags.Optional, 11, string.Empty, SupportedCharacters.AlphaNumericSpecial, 251, string.Empty);
            RequestorField2 = new Field("Requestor Field 2", "OBR.20", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 252, string.Empty);
            ProducerField1 = new Field("Producer Field 1", "OBR.21", "Customer specific accessioning or specimen identification number", RequiredFlags.Optional, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 253, string.Empty);
            ProducerField2 = new Field("Producer Field 2", "OBR.22", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 254, string.Empty);
            DateTimeObservationReported = new Field("Date Time Observation Reported", "OBR.23", "Identify the date and time the results were sent", RequiredFlags.AlwaysRequired, 14, string.Empty, SupportedCharacters.NumericOnly, 255, string.Empty);
            ProducerCharge = new Field("Producer Charge", "OBR.24", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 256, string.Empty);
            ProducerSectionID = new Field("Producer Section ID", "OBR.25", "Identification of the facility responsible for performing the testing", RequiredFlags.Optional, 5, string.Empty, SupportedCharacters.AlphaNumericSpecial, 257, string.Empty);
            OrderResultStatus = new Field("Order Result Status", "OBR.26", "Identification of status of results at the ordered item level", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 258, string.Empty);
            LinkToParentResult = new Field("Link to Parent Result", "OBR.27", "Identifies the test that reflexes creating this lab generated order", RequiredFlags.Conditional, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 259, string.Empty);
            QuantityTiming = new Field("Quantity Timing", "OBR.28", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 221, string.Empty);
            ResultCopiesTo = new Field("Result Copies To", "OBR.29", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 260, string.Empty);
            LinkToParentOrder = new Field("Link to Parent Order", "OBR.30", "Identifies the ordered item containing the test that caused the reflex", RequiredFlags.Optional, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 261, string.Empty);
        }
        public ObservationOrderSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            //The Order Message (ORM) only uses upto 19 field, why the count is 19 and not 29
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            SegmentTypeID.Value = fields.Count > 0 ? fields[0] : String.Empty;
            SequenceNumber.Value = fields.Count > 1 ? fields[1] : String.Empty;
            List<string> components = new List<string>();
            if (fields[2].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'OBR.3'");
                UniqueForeignSpecimenID.Value = fields[2].Trim();
            } else {
                components = new List<string>(fields[2].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter
                if (components.Count != 2) {
                    System.Diagnostics.Debug.WriteLine("Warning - Unexpected number of components returned from field 'OBR.3'.  Expected 2, returned " + components.Count);
                }
                UniqueForeignSpecimenID.Value = components.Count > 0 ? components[0] : String.Empty;
                ForeignApplicationID.Value = components.Count > 1 ? components[1] : String.Empty;
            }
            if (fields[3].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'OBR.4'");
                InternalSpecimenID.Value = fields[3].Trim();
            } else {
                components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count != 2) {
                    System.Diagnostics.Debug.WriteLine("Warning - Unexpected number of components returned from field 'OBR.4'.  Expected 2, returned " + components.Count);
                }
                InternalSpecimenID.Value = components.Count > 0 ? components[0] : String.Empty;
                InternalApplicationID.Value = components.Count > 1 ? components[1] : String.Empty;
            }
            if (fields[4].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'OBR.5'");
                ObservationBatteryID.Value = fields[4].Trim();
            } else {
                components = new List<string>(fields[4].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count != 3) {
                    System.Diagnostics.Debug.WriteLine("Warning - Unexpected number of components returned from field 'OBR.5'.  Expected 3, returned " + components.Count);
                }
                ObservationBatteryID.Value = components.Count > 0 ? components[0] : String.Empty;
                ObservationBatteryText.Value = components.Count > 1 ? components[1] : String.Empty;
                NameOfCodingSystem.Value = components.Count > 2 ? components[2] : String.Empty;
            }
            //Back to non-nested
            this.Priority.Value = fields.Count > 5 ? fields[5] : String.Empty;
            this.RequestedDateTime.Value = fields.Count > 6 ? fields[6] : String.Empty;
            this.ObservationCollectionDateTime.Value = fields.Count > 7 ? fields[7] : String.Empty;
            this.ObservationCollectionEndDateTime.Value = fields.Count > 8 ? fields[8] : String.Empty;
            this.CollectionVolume.Value = fields.Count > 9 ? fields[9] : String.Empty;
            this.CollectorIdentifier.Value = fields.Count > 10 ? fields[10] : String.Empty;
            this.SpecimenActionCode.Value = fields.Count > 11 ? fields[11] : String.Empty;
            this.DangerCode.Value = fields.Count > 12 ? fields[12] : String.Empty;
            //Nested
            if (fields.Count>12 && fields[13].Contains(componentDelimiter)==false){//RelevantClinicalInformation is optional, so might not have a delimiter
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'OBR.14'.  Optional field, so this is probably ok.");
                UnknownField.Value = fields[13].Trim();
            } else if(fields.Count>12) {
                components = new List<string>(fields[13].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components.Count != 2) {
                    System.Diagnostics.Debug.WriteLine("Warning - Unexpected number of components returned from field 'OBR.14'.  Expected 2, returned " + components.Count);
                }
                UnknownField.Value = components.Count > 0 ? components[0] : String.Empty;
                RelevantClinicalInformation.Value = components.Count > 1 ? components[1] : String.Empty;
            }
            //Back to non-nested
            this.SpecimenReceivedDateTime.Value = fields.Count > 14 ? fields[14] : String.Empty;
            this.SpecimenSource.Value = fields.Count > 15 ? fields[15] : String.Empty;
            this.OrderingProvider.Value = fields.Count > 16 ? fields[16] : String.Empty;
            this.OrderingProviderPhoneNumber.Value = fields.Count > 17 ? fields[17] : String.Empty;
            this.AlternateUniqueForeignSpecimenID.Value = fields.Count > 18 ? fields[18] : String.Empty;
            //All these additional fields are used by the Result Message (ORU) only
                this.RequestorField2.Value = fields.Count > 19 ? fields[19] : String.Empty;
                this.ProducerField1.Value =  fields.Count > 20 ? fields[20] : String.Empty;
                this.ProducerField2.Value =  fields.Count > 21 ? fields[21] : String.Empty;
                this.DateTimeObservationReported.Value =  fields.Count > 22 ? fields[22] : String.Empty;
                this.ProducerCharge.Value =  fields.Count > 23 ? fields[23] : String.Empty;
                this.ProducerSectionID.Value =  fields.Count > 24 ? fields[24] : String.Empty;
                this.OrderResultStatus.Value =  fields.Count > 25 ? fields[25] : String.Empty;
                this.LinkToParentResult.Value =  fields.Count > 26 ? fields[26] : String.Empty;
                this.ResultCopiesTo.Value =  fields.Count > 27 ? fields[27] : String.Empty;
                this.LinkToParentOrder.Value =  fields.Count > 28 ? fields[28] : String.Empty;
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 29) {
                for (int x = 29; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "OBR." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public ObservationOrderSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public ObservationOrderSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Setting all field delimiters to the field delimiter, will change component ones below
            foreach (Field observationOrder in this.KnownFields) {
                observationOrder.Delimiter = fieldDelimiter;
            }
            //Components
            foreach (Field observationOrder in new Field[] { UniqueForeignSpecimenID, InternalSpecimenID, ObservationBatteryID, ObservationBatteryText }) {
                observationOrder.Delimiter = componentDelimiter;
            }
            //Last field is always a newline
            LinkToParentOrder.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
