using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class NotesAndCommentsSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _CommentSource = new Field();
        private Field _CommentText = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field CommentSource {
            get {
                return _CommentSource;
            }
            private set {
                _CommentSource = value;
            }
        }
        public Field CommentText {
            get {
                return _CommentText;
            }
            private set {
                _CommentText = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, CommentSource, CommentText });
            }
        }
        public override string SegmentType {
            get {
                return "NTE";
            }
        }
        public override string Title {
            get {
                return "Notes & Comments";
            }
        }
        #endregion
        #region Constructors
        public NotesAndCommentsSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "NTE.1", "To identify the segment", RequiredFlags.Optional, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, this.SegmentType);
            this.SequenceNumber = new Field("Sequence Number", "NTE.2", "To identify the numbet of NTE segments contained within the order file", RequiredFlags.Optional, 4, string.Empty, SupportedCharacters.NumericOnly, 96, string.Empty);
            this.CommentSource = new Field("Comment Source", "NTE.3", "To identify the source of the comment", RequiredFlags.Optional, 1, string.Empty, SupportedCharacters.AlphaOnly, 97, string.Empty);
            this.CommentText = new Field("Comment Text", "NTE.4", "Actual comment text", RequiredFlags.Optional, 78, string.Empty, SupportedCharacters.AlphaNumericSpecial, 98, string.Empty);
        }
        public NotesAndCommentsSegment(string fieldDelimiter):this() {
            //Field Delimiters
            foreach (Field noteAndComment in KnownFields) {
                noteAndComment.Delimiter = fieldDelimiter;
            }
            //Last one is always a newline
            this.CommentText.Delimiter = System.Environment.NewLine;
        }
        public NotesAndCommentsSegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 3) {
                throw new ArgumentException("Not enough fields to construct a valid notes and comments segment (NTE).  Expected at least 3, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.SequenceNumber.Value = fields[1];
            this.CommentSource.Value = fields[2];
            if (fields.Count >= 4) { this.CommentText.Value = fields[3]; }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 4) {
                for (int x = 4; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "NTE." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        #endregion
    }
}
