using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class InsuranceSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _InsurancePlanID = new Field();
        private Field _InsuranceCompanyID = new Field();
        private Field _InsuranceCarrierCode = new Field();
        private Field _InsuranceCompanyName = new Field();
        private Field _InsuranceCompanyAddressLine1 = new Field();
        private Field _InsuranceCompanyAddressLine2 = new Field();
        private Field _InsuranceCompanyCity = new Field();
        private Field _InsuranceCompanyState = new Field();
        private Field _InsuranceCompanyZipCode = new Field();
        private Field _InsuranceCompanyContactName = new Field();
        private Field _InsuranceCompanyPhoneNumber = new Field();
        private Field _GroupNumberOfInsuredPatient = new Field();
        private Field _GroupName = new Field();
        private Field _InsuredsGroupEmployerID = new Field();
        private Field _InsuredsGroupEmployerName = new Field();
        private Field _PlanEffectiveDateTime = new Field();
        private Field _PlanExpirationDateTime = new Field();
        private Field _AuthorizationInformation = new Field();
        private Field _PlanType = new Field();
        private Field _NameOfInsured = new Field();
        private Field _GuarantorRelationshipToPatient = new Field();
        private Field _InsuredsDateOfBirth = new Field();
        private Field _InsuredsAddress = new Field();
        private Field _AssignmentOfBenefits = new Field();
        private Field _CoordinatorOfBenefits = new Field();
        private Field _PrimaryPayor = new Field();
        private Field _NoticeOfAdmissionCode = new Field();
        private Field _NoticeOfAdmissionDateTime = new Field();
        private Field _ReportOfEligibilityFlag = new Field();
        private Field _ReportOfEligibilityDateTime = new Field();
        private Field _ReleaseInformationCode = new Field();
        private Field _PreAdmitCertification = new Field();
        private Field _VerificationDateTime = new Field();
        private Field _VerificationBy = new Field();
        private Field _TypeOfAgreement = new Field();
        private Field _BillingStatus = new Field();
        private Field _LifetimeReserveDays = new Field();
        private Field _DelayBeforeLifetimeReserveDays = new Field();
        private Field _CompanyPlanCode = new Field();
        private Field _InsuranceNumber = new Field();
        private Field _PolicyDeductible = new Field();
        private Field _PolicyLimitAmount = new Field();
        private Field _PolicyLimitDays = new Field();
        private Field _RoomRateSemiPrivate = new Field();
        private Field _RoomRatePrivate = new Field();
        private Field _InsuredsEmployementStatus = new Field();
        private Field _InsuredsSex = new Field();
        private Field _InsuredsEmployerAddress = new Field();
        private Field _VerificationStatus = new Field();
        private Field _PriorInsurancePlanID = new Field();
        private Field _CoverageType = new Field();
        private Field _Handicap = new Field();
        private Field _InsuredsIDNumber = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field InsurancePlanID {
            get {
                return _InsurancePlanID;
            }
            private set {
                _InsurancePlanID = value;
            }
        }
        public Field InsuranceCompanyID {
            get {
                return _InsuranceCompanyID;
            }
            private set {
                _InsuranceCompanyID = value;
            }
        }
        public Field InsuranceCarrierCode {
            get {
                return _InsuranceCarrierCode;
            }
            private set {
                _InsuranceCarrierCode = value;
            }
        }
        public Field InsuranceCompanyName {
            get {
                return _InsuranceCompanyName;
            }
            private set {
                _InsuranceCompanyName = value;
            }
        }
        public Field InsuranceCompanyAddressLine1 {
            get {
                return _InsuranceCompanyAddressLine1;
            }
            private set {
                _InsuranceCompanyAddressLine1 = value;
            }
        }
        public Field InsuranceCompanyAddressLine2 {
            get {
                return _InsuranceCompanyAddressLine2;
            }
            private set {
                _InsuranceCompanyAddressLine2 = value;
            }
        }
        public Field InsuranceCompanyCity {
            get {
                return _InsuranceCompanyCity;
            }
            private set {
                _InsuranceCompanyCity = value;
            }
        }
        public Field InsuranceCompanyState {
            get {
                return _InsuranceCompanyState;
            }
            private set {
                _InsuranceCompanyState = value;
            }
        }
        public Field InsuranceCompanyZipCode {
            get {
                return _InsuranceCompanyZipCode;
            }
            private set {
                _InsuranceCompanyZipCode = value;
            }
        }
        public Field InsuranceCompanyContactName {
            get {
                return _InsuranceCompanyContactName;
            }
            private set {
                _InsuranceCompanyContactName = value;
            }
        }
        public Field InsuranceCompanyPhoneNumber {
            get {
                return _InsuranceCompanyPhoneNumber;
            }
            private set {
                _InsuranceCompanyPhoneNumber = value;
            }
        }
        public Field GroupNumberOfInsuredPatient {
            get {
                return _GroupNumberOfInsuredPatient;
            }
            private set {
                _GroupNumberOfInsuredPatient = value;
            }
        }
        public Field GroupName {
            get {
                return _GroupName;
            }
            private set {
                _GroupName = value;
            }
        }
        public Field InsuredsGroupEmployerID {
            get {
                return _InsuredsGroupEmployerID;
            }
            private set {
                _InsuredsGroupEmployerID = value;
            }
        }
        public Field InsuredsGroupEmployerName {
            get {
                return _InsuredsGroupEmployerName;
            }
            private set {
                _InsuredsGroupEmployerName = value;
            }
        }
        public Field PlanEffectiveDateTime {
            get {
                return _PlanEffectiveDateTime;
            }
            private set {
                _PlanEffectiveDateTime = value;
            }
        }
        public Field PlanExpirationDateTime {
            get {
                return _PlanExpirationDateTime;
            }
            private set {
                _PlanExpirationDateTime = value;
            }
        }
        public Field AuthorizationInformation {
            get {
                return _AuthorizationInformation;
            }
            private set {
                _AuthorizationInformation = value;
            }
        }
        public Field PlanType {
            get {
                return _PlanType;
            }
            private set {
                _PlanType = value;
            }
        }
        public Field NameOfInsured {
            get {
                return _NameOfInsured;
            }
            private set {
                _NameOfInsured = value;
            }
        }
        public Field GuarantorRelationshipToPatient {
            get {
                return _GuarantorRelationshipToPatient;
            }
            private set {
                _GuarantorRelationshipToPatient = value;
            }
        }
        public Field InsuredsDateOfBirth {
            get {
                return _InsuredsDateOfBirth;
            }
            private set {
                _InsuredsDateOfBirth = value;
            }
        }
        public Field InsuredsAddress {
            get {
                return _InsuredsAddress;
            }
            private set {
                _InsuredsAddress = value;
            }
        }
        public Field AssignmentOfBenefits {
            get {
                return _AssignmentOfBenefits;
            }
            private set {
                _AssignmentOfBenefits = value;
            }
        }
        public Field CoordinatorOfBenefits {
            get {
                return _CoordinatorOfBenefits;
            }
            private set {
                _CoordinatorOfBenefits = value;
            }
        }
        public Field PrimaryPayor {
            get {
                return _PrimaryPayor;
            }
            private set {
                _PrimaryPayor = value;
            }
        }
        public Field NoticeOfAdmissionCode {
            get {
                return _NoticeOfAdmissionCode;
            }
            private set {
                _NoticeOfAdmissionCode = value;
            }
        }
        public Field NoticeOfAdmissionDateTime {
            get {
                return _NoticeOfAdmissionDateTime;
            }
            private set {
                _NoticeOfAdmissionDateTime = value;
            }
        }
        public Field ReportOfEligibilityFlag {
            get {
                return _ReportOfEligibilityFlag;
            }
            private set {
                _ReportOfEligibilityFlag = value;
            }
        }
        public Field ReportOfEligibilityDateTime {
            get {
                return _ReportOfEligibilityDateTime;
            }
            private set {
                _ReportOfEligibilityDateTime = value;
            }
        }
        public Field ReleaseInformationCode {
            get {
                return _ReleaseInformationCode;
            }
            private set {
                _ReleaseInformationCode = value;
            }
        }
        public Field PreAdmitCertification {
            get {
                return _PreAdmitCertification;
            }
            private set {
                _PreAdmitCertification = value;
            }
        }
        public Field VerificationDateTime {
            get {
                return _VerificationDateTime;
            }
            private set {
                _VerificationDateTime = value;
            }
        }
        public Field VerificationBy {
            get {
                return _VerificationBy;
            }
            private set {
                _VerificationBy = value;
            }
        }
        public Field TypeOfAgreement {
            get {
                return _TypeOfAgreement;
            }
            private set {
                _TypeOfAgreement = value;
            }
        }
        public Field BillingStatus {
            get {
                return _BillingStatus;
            }
            private set {
                _BillingStatus = value;
            }
        }
        public Field LifetimeReserveDays {
            get {
                return _LifetimeReserveDays;
            }
            private set {
                _LifetimeReserveDays = value;
            }
        }
        public Field DelayBeforeLifetimeReserveDays {
            get {
                return _DelayBeforeLifetimeReserveDays;
            }
            private set {
                _DelayBeforeLifetimeReserveDays = value;
            }
        }
        public Field CompanyPlanCode {
            get {
                return _CompanyPlanCode;
            }
            private set {
                _CompanyPlanCode = value;
            }
        }
        public Field InsuranceNumber {
            get {
                return _InsuranceNumber;
            }
            private set {
                _InsuranceNumber = value;
            }
        }
        public Field PolicyDeductible {
            get { return _PolicyDeductible; }
            set { _PolicyDeductible = value; }
        }
        public Field PolicyLimitAmount {
            get { return _PolicyLimitAmount; }
            set { _PolicyLimitAmount = value; }
        }
        public Field PolicyLimitDays {
            get { return _PolicyLimitDays; }
            set { _PolicyLimitDays = value; }
        }
        public Field RoomRateSemiPrivate {
            get { return _RoomRateSemiPrivate; }
            set { _RoomRateSemiPrivate = value; }
        }
        public Field RoomRatePrivate {
            get { return _RoomRatePrivate; }
            set { _RoomRatePrivate = value; }
        }
        public Field InsuredsEmployementStatus {
            get { return _InsuredsEmployementStatus; }
            set { _InsuredsEmployementStatus = value; }
        }
        public Field InsuredsSex {
            get { return _InsuredsSex; }
            set { _InsuredsSex = value; }
        }
        public Field InsuredsEmployerAddress {
            get { return _InsuredsEmployerAddress; }
            set { _InsuredsEmployerAddress = value; }
        }
        public Field VerificationStatus {
            get { return _VerificationStatus; }
            set { _VerificationStatus = value; }
        }
        public Field PriorInsurancePlanID {
            get { return _PriorInsurancePlanID; }
            set { _PriorInsurancePlanID = value; }
        }
        public Field CoverageType {
            get { return _CoverageType; }
            set { _CoverageType = value; }
        }
        public Field Handicap {
            get { return _Handicap; }
            set { _Handicap = value; }
        }
        public Field InsuredsIDNumber {
            get { return _InsuredsIDNumber; }
            set { _InsuredsIDNumber = value; }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { 
                    SegmentTypeID, 
                    SequenceNumber, 
                    InsurancePlanID, 
                    InsuranceCompanyID, 
                    InsuranceCarrierCode, 
                    InsuranceCompanyName, 
                    InsuranceCompanyAddressLine1, 
                    InsuranceCompanyAddressLine2, 
                    InsuranceCompanyCity, 
                    InsuranceCompanyState, 
                    InsuranceCompanyZipCode, 
                    InsuranceCompanyContactName, 
                    InsuranceCompanyPhoneNumber, 
                    GroupNumberOfInsuredPatient, 
                    GroupName, 
                    InsuredsGroupEmployerID, 
                    InsuredsGroupEmployerName, 
                    PlanEffectiveDateTime, 
                    PlanExpirationDateTime, 
                    AuthorizationInformation, 
                    PlanType, 
                    NameOfInsured, 
                    GuarantorRelationshipToPatient, 
                    InsuredsDateOfBirth, 
                    InsuredsAddress, 
                    AssignmentOfBenefits, 
                    CoordinatorOfBenefits, 
                    PrimaryPayor, 
                    NoticeOfAdmissionCode, 
                    NoticeOfAdmissionDateTime, 
                    ReportOfEligibilityFlag, 
                    ReportOfEligibilityDateTime, 
                    ReleaseInformationCode, 
                    PreAdmitCertification, 
                    VerificationDateTime, 
                    VerificationBy, 
                    TypeOfAgreement, 
                    BillingStatus, 
                    LifetimeReserveDays, 
                    DelayBeforeLifetimeReserveDays, 
                    CompanyPlanCode, 
                    InsuranceNumber,
                    PolicyDeductible, 
                    PolicyLimitAmount, 
                    PolicyLimitDays,
                    RoomRateSemiPrivate,
                    RoomRatePrivate,
                    InsuredsEmployementStatus,
                    InsuredsSex,
                    InsuredsEmployerAddress,
                    VerificationStatus,
                    PriorInsurancePlanID,
                    CoverageType,
                    Handicap,
                    InsuredsIDNumber
                });
            }
        }
        public override string SegmentType {
            get {
                return "IN1";
            }
        }
        public override string Title {
            get {
                return "Insurance";
            }
        }
        #endregion
        #region Constructors
        public InsuranceSegment() {
            SegmentTypeID = new Field("Segment Type ID", "IN1.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaNumeric, 0, "IN1");
            SequenceNumber = new Field("Sequence Number", "IN1.2", "To identify the number of IN1 segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.Unused, 426, string.Empty);
            InsurancePlanID = new Field("Insurance Plan ID ", "IN1.3", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 368, string.Empty);
            InsuranceCompanyID = new Field("Insurance Company Identification Number", "IN1.4", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 428, string.Empty);
            InsuranceCarrierCode = new Field("Insurance Carrier Code", "IN1.4", "routes billing to the appropriate Insurance/HMO company", RequiredFlags.AlwaysRequired, 5, string.Empty, SupportedCharacters.AlphaNumericSpecial, 428, string.Empty);
            InsuranceCompanyName = new Field("Insurance Company Name  ", "IN1.5", "To identify the appropriate Insurance/HMO company", RequiredFlags.Conditional, 30, string.Empty, SupportedCharacters.AlphaNumericSpecial, 429, string.Empty);
            InsuranceCompanyAddressLine1 = new Field("Insurance Company Address Line 1", "IN1.6", "To identify the appropriate Insurance/HMO company", RequiredFlags.Conditional, 35, string.Empty, SupportedCharacters.AlphaNumericSpecial, 430, string.Empty);
            InsuranceCompanyAddressLine2 = new Field("Insurance Company Address Line 2", "IN1.6", "To identify the appropriate Insurance/HMO company", RequiredFlags.Conditional, 35, string.Empty, SupportedCharacters.AlphaNumericSpecial, 430, string.Empty);
            InsuranceCompanyCity = new Field("Insurance Company City", "IN1.6", "To identify the appropriate Insurance/HMO company", RequiredFlags.Conditional, 16, string.Empty, SupportedCharacters.AlphaOnly, 430, string.Empty);
            InsuranceCompanyState = new Field("Insurance Company State ", "IN1.6", "To bill to the appropriate Insurance/HMO company", RequiredFlags.Conditional, 2, string.Empty, SupportedCharacters.AlphaOnly, 430, string.Empty);
            InsuranceCompanyZipCode = new Field("Insurance Company Zip Code", "IN1.6", "To bill to the appropriate Insurance/HMO company", RequiredFlags.Conditional, 9, string.Empty, SupportedCharacters.NumericOnly, 430, string.Empty);
            InsuranceCompanyContactName = new Field("Insurance Company Contact Name", "IN1.7", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 431, string.Empty);
            InsuranceCompanyPhoneNumber = new Field("Insurance Company Phone Number", "IN1.8", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 432, string.Empty);
            GroupNumberOfInsuredPatient = new Field("Group Number of Insured Patient ", "IN1.9", "Required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 433, string.Empty);
            GroupName = new Field("Group Name", "IN1.10", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 434, string.Empty);
            InsuredsGroupEmployerID = new Field("Insureds Group Employer ID", "IN1.11", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 435, string.Empty);
            InsuredsGroupEmployerName = new Field("Insureds Group Employer Name", "IN1.12", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 436, string.Empty);
            PlanEffectiveDateTime = new Field("Plan Effective Date / Time", "IN1.13", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 437, string.Empty);
            PlanExpirationDateTime = new Field("Plan Expiration Date / Time", "IN1.14", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 438, string.Empty);
            AuthorizationInformation = new Field("Authorization Information", "IN1.15", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 439, string.Empty);
            PlanType = new Field("Plan Type", "IN1.16", "Designation of the insurance type this IN1 segment supports", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaOnly, 440, string.Empty);
            NameOfInsured = new Field("Name of Insured", "IN1.17", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 441, string.Empty);
            GuarantorRelationshipToPatient = new Field("Guarantor Relationship to Patient ", "IN1.18", "To identify the relationship of the patient to the subscriber", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.NumericOnly, 442, string.Empty);
            InsuredsDateOfBirth = new Field("Insureds Date of Birth", "IN1.19", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 443, string.Empty);
            InsuredsAddress = new Field("Insureds Address", "IN1.20", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 444, string.Empty);
            AssignmentOfBenefits = new Field("Assignment of Benefits", "IN1.21", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 445, string.Empty);
            CoordinatorOfBenefits = new Field("Coordinator of Benefits", "IN1.22", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 446, string.Empty);
            PrimaryPayor = new Field("Primary Payor", "IN1.23", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 447, string.Empty);
            NoticeOfAdmissionCode = new Field("Notice of Admission Code", "IN1.24", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 448, string.Empty);
            NoticeOfAdmissionDateTime = new Field("Notice of Admission Date / Time", "IN1.25", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 449, string.Empty);
            ReportOfEligibilityFlag = new Field("Report of Eligibility Flag", "IN1.26", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 450, string.Empty);
            ReportOfEligibilityDateTime = new Field("Report of Eligibility Date/Time", "IN1.27", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 451, string.Empty);
            ReleaseInformationCode = new Field("Release Information Code", "IN1.28", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 452, string.Empty);
            PreAdmitCertification = new Field("Pre-admit Certification", "IN1.29", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 453, string.Empty);
            VerificationDateTime = new Field("Verification Date/Time", "IN1.30", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 454, string.Empty);
            VerificationBy = new Field("Verification By", "IN1.31", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 455, string.Empty);
            TypeOfAgreement = new Field("Type of Agreement", "IN1.32", "Workers Compensation Flag", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 456, string.Empty);
            BillingStatus = new Field("Billing Status", "IN1.33", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 457, string.Empty);
            LifetimeReserveDays = new Field("Lifetime Reserve Days", "IN1.34", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 458, string.Empty);
            DelayBeforeLifetimeReserveDays = new Field("Delay before Lifetime Reserve Days", "IN1.35", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 459, string.Empty);
            CompanyPlanCode = new Field("Company Plan Code", "IN1.36", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 460, string.Empty);
            InsuranceNumber = new Field("Insurance Number", "IN1.37", "Required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 461, string.Empty);
            PolicyDeductible = new Field("Policy Deductible", "IN1.38", string.Empty, RequiredFlags.Unused, 12, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            PolicyLimitAmount = new Field("PolicyLimitAmount", "IN1.39", string.Empty, RequiredFlags.Unused, 12, string.Empty, SupportedCharacters.Unused, 463, string.Empty);
            PolicyLimitDays = new Field("PolicyLimitDays", "IN1.40", string.Empty, RequiredFlags.Unused, 4, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            RoomRateSemiPrivate = new Field("RoomRateSemiPrivate", "IN1.41", string.Empty, RequiredFlags.Unused, 12, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            RoomRatePrivate = new Field("RoomRatePrivate", "IN1.42", string.Empty, RequiredFlags.Unused, 12, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            InsuredsEmployementStatus = new Field("InsuredsEmployementStatus", "IN1.43", string.Empty, RequiredFlags.Unused, 60, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            InsuredsSex = new Field("InsuredsSex", "IN1.44", string.Empty, RequiredFlags.Unused, 1, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            InsuredsEmployerAddress = new Field("InsuredsEmployerAddress", "IN1.45", string.Empty, RequiredFlags.Unused, 106, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            VerificationStatus = new Field("VerificationStatus", "IN1.46", string.Empty, RequiredFlags.Unused, 2, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            PriorInsurancePlanID = new Field("PriorInsurancePlanID", "IN1.47", string.Empty, RequiredFlags.Unused, 8, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            CoverageType = new Field("CoverageType", "IN1.48", string.Empty, RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 462, string.Empty);
            Handicap = new Field("Handicap", "IN1.49", string.Empty, RequiredFlags.Unused, 2, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
            InsuredsIDNumber = new Field("InsuredsIDNumber", "IN1.50", string.Empty, RequiredFlags.Unused, 12, string.Empty, SupportedCharacters.Unused, 462, string.Empty);
        }
        public InsuranceSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 37) {
                throw new ArgumentException("Not enough fields to construct a valid insurance segment (IN1).  Expected at least 37, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.SequenceNumber.Value = fields[1];
            this.InsurancePlanID.Value = fields[2];
            List<string> components = new List<string>();
            if (fields[3].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning:  Missing component delimiter in field 'IN1.4'");
                this.InsuranceCompanyID.Value = fields[3].Trim();
            } else {
                components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter
                if (components.Count != 2) {
                    throw new ArgumentException("Unexpected number of components returned for the field 'IN1.4'.  Expected 2, returned " + components.Count);
                }
                this.InsuranceCompanyID.Value = components[0];
                this.InsuranceCarrierCode.Value = components[1];
            }
            //Back to a non-nested
            this.InsuranceCompanyName.Value = fields[4];
            //Nested again
            if (fields[5].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'IN1.6'");
            }
            components = new List<string>(fields[5].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            if (components.Count != 5) {
                throw new ArgumentException("Unexpected number of components returned for the field 'IN1.6'.  Expected 2, returned " + components.Count);
            }
            this.InsuranceCompanyAddressLine1.Value = components[0];
            this.InsuranceCompanyAddressLine2.Value = components[1];
            this.InsuranceCompanyCity.Value = components[2];
            this.InsuranceCompanyState.Value = components[3];
            this.InsuranceCompanyZipCode.Value = components[4];
            //Back to non-nested
            this.InsuranceCompanyContactName.Value = fields[6];
            this.InsuranceCompanyPhoneNumber.Value = fields[7];
            this.GroupNumberOfInsuredPatient.Value = fields[8];
            this.GroupName.Value = fields[9];
            this.InsuredsGroupEmployerID.Value = fields[10];
            this.InsuredsGroupEmployerName.Value = fields[11];
            this.PlanEffectiveDateTime.Value = fields[12];
            this.PlanExpirationDateTime.Value = fields[13];
            this.AuthorizationInformation.Value = fields[14];
            this.PlanType.Value = fields[15];
            this.NameOfInsured.Value = fields[16];
            this.GuarantorRelationshipToPatient.Value = fields[17];
            this.InsuredsDateOfBirth.Value = fields[18];
            this.InsuredsAddress.Value = fields[19];
            this.AssignmentOfBenefits.Value = fields[20];
            this.CoordinatorOfBenefits.Value = fields[21];
            this.PrimaryPayor.Value = fields[22];
            this.NoticeOfAdmissionCode.Value = fields[23];
            this.NoticeOfAdmissionDateTime.Value = fields[24];
            this.ReportOfEligibilityFlag.Value = fields[25];
            this.ReportOfEligibilityDateTime.Value = fields[26];
            this.ReleaseInformationCode.Value = fields[27];
            this.PreAdmitCertification.Value = fields[28];
            this.VerificationDateTime.Value = fields[29];
            this.VerificationBy.Value = fields[30];
            this.TypeOfAgreement.Value = fields[31];
            this.BillingStatus.Value = fields[32];
            this.LifetimeReserveDays.Value = fields[33];
            this.DelayBeforeLifetimeReserveDays.Value = fields[34];
            this.CompanyPlanCode.Value = fields[35];
            this.InsuranceNumber.Value = fields[36];
            if (fields.Count >= 37) { this.PolicyDeductible.Value = fields[37]; }
            if (fields.Count >= 38) { this.PolicyLimitAmount.Value = fields[38]; }
            if (fields.Count >= 39) { this.PolicyLimitDays.Value = fields[39]; }
            if (fields.Count >= 40) { this.RoomRateSemiPrivate.Value = fields[40]; }
            if (fields.Count >= 41) { this.RoomRatePrivate.Value = fields[41]; }
            if (fields.Count >= 42) { this.InsuredsEmployementStatus.Value = fields[42]; }
            if (fields.Count >= 43) { this.InsuredsSex.Value = fields[43]; }
            if (fields.Count >= 44) { this.InsuredsEmployerAddress.Value = fields[44]; }
            if (fields.Count >= 45) { this.VerificationStatus.Value = fields[45]; }
            if (fields.Count >= 46) { this.PriorInsurancePlanID.Value = fields[46]; }
            if (fields.Count >= 47) { this.CoverageType.Value = fields[47]; }
            if (fields.Count >= 48) { this.Handicap.Value = fields[48]; }
            if (fields.Count >= 49) { this.InsuredsIDNumber.Value = fields[49]; }            
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 50) {
                for (int x = 50; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "IN1." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public InsuranceSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public InsuranceSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field patientVisit in KnownFields) {
                patientVisit.Delimiter = fieldDelimiter;
            }
            //Nested field delimiters
            foreach (Field patientVisit in new Field[] { InsuranceCompanyID, InsuranceCompanyAddressLine1, InsuranceCompanyAddressLine2, InsuranceCompanyCity, InsuranceCompanyState }) {
                patientVisit.Delimiter = componentDelimiter;
            }
            //last delimiter is always a newline
            this.InsuredsIDNumber.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
