using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class Field {
        #region Private Instance Variables
        private string _Title;
        private string _Mnemonic;
        private string _Usage;
        private RequiredFlags _RequiredFlag = RequiredFlags.Unknown;
        private int _MaxLength = -1;
        private string _Delimiter;
        private SupportedCharacters _SupportedCharacters = SupportedCharacters.Unused;
        private int _HL7DataElement = -1;
        private string _Value;
        #endregion
        #region Constructors
        public Field(String title, string mnemonic, string usage, RequiredFlags requiredFlag, int maxLength, string fieldDelimiter, SupportedCharacters validCharacters, int hl7DataElement, string value)
            : this() {
            this.Title = title;
            this.Mnemonic = mnemonic;
            this.Usage = usage;
            this.RequiredFlag = requiredFlag;
            this.MaxLength = maxLength;
            this.Delimiter = fieldDelimiter;
            this._SupportedCharacters = validCharacters;
            this.HL7DataElement = hl7DataElement;
            this.Value = value;
        }
        public Field() {//Just to have a New()
            this.Value = string.Empty;
        }
        #endregion
        #region Public Instance Properties
        public string Title {
            get {
                return _Title;
            }
            private set {
                _Title = value;
            }
        }
        public string Mnemonic {
            get {
                return _Mnemonic;
            }
            private set {
                _Mnemonic = value;
            }
        }
        public string Usage {
            get {
                return _Usage;
            }
            private set {
                _Usage = value;
            }
        }
        public RequiredFlags RequiredFlag {
            get {
                return _RequiredFlag;
            }
            private set {
                _RequiredFlag = value;
            }
        }
        public int MaxLength {
            get {
                return _MaxLength;
            }
            private set {
                _MaxLength = value;
            }
        }
        public string Delimiter {
            get {
                return _Delimiter;
            }
            set {
                _Delimiter = value;
            }
        }
        public string ValidCharacters {
            get {
                return GetSupportedCharacters(_SupportedCharacters);
            }

        }
        public int HL7DataElement {
            get {
                return _HL7DataElement;
            }
            private set {
                _HL7DataElement = value;
            }
        }
        public string Value {
            get {
                return _Value;
            }
            set {
                _Value = value;
            }
        }
        static string GetSupportedCharacters(SupportedCharacters supported) {
            switch (supported) {
                case SupportedCharacters.AlphaOnly:
                    return "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                case SupportedCharacters.NumericOnly:
                    return "0123456789";
                case SupportedCharacters.SpecialOnly:
                    return @"~!@#$%^&*()_+{}|:<>?[]\;',./""";
                case SupportedCharacters.AlphaNumeric:
                    return GetSupportedCharacters(SupportedCharacters.AlphaOnly) + GetSupportedCharacters(SupportedCharacters.NumericOnly);
                case SupportedCharacters.AlphaSpecial:
                    return GetSupportedCharacters(SupportedCharacters.AlphaOnly) + GetSupportedCharacters(SupportedCharacters.SpecialOnly);
                case SupportedCharacters.NumericSpecial:
                    return GetSupportedCharacters(SupportedCharacters.NumericOnly) + GetSupportedCharacters(SupportedCharacters.SpecialOnly);
                case SupportedCharacters.AlphaNumericSpecial:
                    return GetSupportedCharacters(SupportedCharacters.AlphaOnly) + GetSupportedCharacters(SupportedCharacters.NumericOnly) + GetSupportedCharacters(SupportedCharacters.SpecialOnly);
                case SupportedCharacters.Unused:
                    return string.Empty;
            }
            return string.Empty;
        }
        public string RightSideDelimitedValue {
            get {
                return this.Value + this.Delimiter;
            }
        }
        #endregion
        #region Public Instance Methods
        public override string ToString() {
            return this.Value;
        }
        #endregion
    }
}
