using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    //This was implemented for Boswik Labratories.
    //They used a differnt numbering scheme for the nmenomic, they start from 0, Labcorp started from 1
    public class EmbeddedImageSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _Base64Image = new Field();
        private Field _ReportStatus = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field Base64Image {
            get {
                return _Base64Image;
            }
            private set {
                _Base64Image = value;
            }
        }
        public Field ReportStatus {
            get {
                return _ReportStatus;
            }
            private set {
                _ReportStatus = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, Base64Image, ReportStatus });
            }
        }
        #endregion
        #region Constructors
        public EmbeddedImageSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ZEF.0", "To identify the segment", RequiredFlags.Optional, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, SegmentType);
            this.SequenceNumber = new Field("Sequence Number", "ZEF.1", "To identify the number of ZEF segments contained within the result file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 1, string.Empty);
            this.Base64Image = new Field("Base64 Image", "ZEF.2", "Base64 encrypted message data", RequiredFlags.AlwaysRequired, 99999999, string.Empty, SupportedCharacters.AlphaNumericSpecial, 2, string.Empty);
            this.ReportStatus = new Field("Report Status", "ZEF.3", "Report Status", RequiredFlags.AlwaysRequired, 10, string.Empty, SupportedCharacters.AlphaOnly, 3, string.Empty);
        }
        public EmbeddedImageSegment(string fieldDelimiter) : this() {
            //Non-nested field delimiters
            foreach (Field field in KnownFields) {
                field.Delimiter = fieldDelimiter;
            }
        }
        public EmbeddedImageSegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 3) {
                throw new ArgumentException("Not enough fields to construct a valid embedded image segment (ZEF).  Expected at least 3, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.SequenceNumber.Value = fields[1];
            this.Base64Image.Value = fields[2];
            if (fields.Count == 4) {
                this.ReportStatus.Value = fields[3];
            }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 4) {
                for (int x = 2; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZEF." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        #endregion
        public override string SegmentType {
            get {
                return "ZEF";
            }
        }
        public override string Title {
            get {
                return "Embedded Image";
            }
        }
    }
}
