using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    //So we can use data-binding with value for easy setting/retrivial
    public struct CodeDescription {
        private char _Code;
        private string _Description;
        public CodeDescription(char code, string description)
            : this() {
            _Code = code;
            _Description = description == null ? string.Empty : description.Trim().ToUpper();
        }
        public char Code {
            get { return _Code; }
            set {
                _Code = value;
            }
        }
        public string Description {
            get { return _Description.Trim().ToUpper(); }
            set {
                _Description = value == null ? string.Empty : value.Trim().ToUpper();
            }
        }
        public static bool ContainsCode(char code, List<CodeDescription> list) {
            foreach (CodeDescription cd in list) {
                if (cd.Code == code) { return true; }
            }
            return false;
        }
        public static bool ContainsCode(string code, List<CodeDescription> list) {
            char c;
            bool parsed = char.TryParse(code, out c);
            if (!parsed) {
                System.Diagnostics.Debug.WriteLine("CodeDescription - ContainsCode - char.TryParse failed on string: " + code);
                return false; 
            }
            return ContainsCode(c, list);
        }
    }
}
