using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class AddendumSegment:Segment {
        #region Private Instance Variables
        private Field _ContinuationOfPreviousLogicalRecord = new Field();
        #endregion
        #region Public Instance Properties
        public Field ContinuationOfPreviousLogicalRecord {
            get {
                return _ContinuationOfPreviousLogicalRecord;
            }
            private set {
                _ContinuationOfPreviousLogicalRecord = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, ContinuationOfPreviousLogicalRecord });
            }
        }
        #endregion
        #region Constructors
        public AddendumSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ADD.1", "To identify the segment", RequiredFlags.Optional, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.ContinuationOfPreviousLogicalRecord = new Field("Continuation of Previous Logical Record", "ADD.2", "Continuation of Previous Logical Record", RequiredFlags.Optional, 215, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
        }
        public AddendumSegment(string message, string fieldDelimiter)
            : this() {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 2) {
                throw new ArgumentException("Not enough fields to construct a valid addendum segment (ADD).  Expected at least 2, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.ContinuationOfPreviousLogicalRecord.Value = fields[1];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 2) {
                for (int x = 2; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ADD." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
            //Field Delimiter
            this.SegmentTypeID.Delimiter = fieldDelimiter;
            //Last one is always a newline
            this.ContinuationOfPreviousLogicalRecord.Delimiter = System.Environment.NewLine;
        }
        #endregion
        public override string SegmentType {
            get {
                return "ADD";
            }
        }
        public override string Title {
            get {
                return "Addendum";
            }
        }
    }
}
