using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class SuperAlphaFetaProteinSegment : Segment {
        #region Private Instance Variables
        private Field _InsulinDependent = new Field();
        private Field _GestationAgeWeeks = new Field();
        private Field _GestationalAgeDays = new Field();
        private Field _GestationalAgeDecimalForm = new Field();
        private Field _GestationalAgeDate = new Field();
        private Field _GestationalAgeCalculationMethodByLastMenstrualPeriod = new Field();
        private Field _LastMenstrualPeriodDate = new Field();
        private Field _GestationalAgeCalculationMethodByUltrasound = new Field();
        private Field _UltrasoundDate = new Field();
        private Field _GestationalAgeCalculationMethodByEstimatedDateOfDelivery = new Field();
        private Field _EstimatedDateOfDeliveryDate = new Field();
        private Field _TypeOfPregnancy = new Field();
        private Field _RoutineScreening = new Field();
        private Field _PreviousNeuralTubeDefects = new Field();
        private Field _AdvancedMaternalAge = new Field();
        private Field _HistoryOfDownSyndrome = new Field();
        private Field _HistoryOfCysticFibrosis = new Field();
        private Field _OtherIndications = new Field();
        private Field _HandWrittenAFPInfo = new Field();
        private Field _ReasonForRepeatElevated = new Field();
        private Field _EarlyGA = new Field();
        private Field _Hemolyzed = new Field();
        private Field _UltrasoundMeasurementCrownRumpLength = new Field();
        private Field _UltrasoundMeasurementCrownRumpLengthDate = new Field();
        private Field _UltrasoundMeasurementCrownRumpLengthForTwinB = new Field();
        private Field _NuchalTranslucency = new Field();
        private Field _NuchalTranslucencyForTwinB = new Field();
        private Field _DonerEgg = new Field();
        private Field _AgeOfEggDonor = new Field();
        private Field _PriorDownSyndromeScreeningDuringCurrentPregnancy = new Field();
        private Field _PriorFirstTrimesterTesting = new Field();
        private Field _PriorSecondTrimesterTesting = new Field();
        private Field _FamilyHistoryOfNeuralTubeDefects = new Field();
        private Field _PriorPregnancyWithDownSyndrome = new Field();
        private Field _ChorionictyMonochorionic = new Field();
        private Field _ChorionictyDichorionic = new Field();
        private Field _ChorionictyUnknown = new Field();
        private Field _SonographerLastName = new Field();
        private Field _SonographerFirstName = new Field();
        private Field _SonographerIDNumber = new Field();
        private Field _CredentialedByNTQR = new Field();
        private Field _CredentialedByFMF = new Field();
        private Field _CredentialedByOtherOrganization = new Field();
        private Field _SiteNumber = new Field();
        private Field _ReadingPhysicianID = new Field();


        #endregion
        #region Public Instance Properties
        public Field InsulinDependent {
            get {
                return _InsulinDependent;
            }
            private set {
                _InsulinDependent = value;
            }
        }
        public Field GestationAgeWeeks {
            get {
                return _GestationAgeWeeks;
            }
            private set {
                _GestationAgeWeeks = value;
            }
        }
        public Field GestationalAgeDays {
            get {
                return _GestationalAgeDays;
            }
            private set {
                _GestationalAgeDays = value;
            }
        }
        public Field GestationalAgeDecimalForm {
            get {
                return _GestationalAgeDecimalForm;
            }
            private set {
                _GestationalAgeDecimalForm = value;
            }
        }
        public Field GestationalAgeDate {
            get {
                return _GestationalAgeDate;
            }
            private set {
                _GestationalAgeDate = value;
            }
        }
        public Field GestationalAgeCalculationMethodByLastMenstrualPeriod {
            get {
                return _GestationalAgeCalculationMethodByLastMenstrualPeriod;
            }
            private set {
                _GestationalAgeCalculationMethodByLastMenstrualPeriod = value;
            }
        }
        public Field LastMenstrualPeriodDate {
            get {
                return _LastMenstrualPeriodDate;
            }
            private set {
                _LastMenstrualPeriodDate = value;
            }
        }
        public Field GestationalAgeCalculationMethodByUltrasound {
            get {
                return _GestationalAgeCalculationMethodByUltrasound;
            }
            private set {
                _GestationalAgeCalculationMethodByUltrasound = value;
            }
        }
        public Field UltrasoundDate {
            get {
                return _UltrasoundDate;
            }
            private set {
                _UltrasoundDate = value;
            }
        }
        public Field GestationalAgeCalculationMethodByEstimatedDateOfDelivery {
            get {
                return _GestationalAgeCalculationMethodByEstimatedDateOfDelivery;
            }
            private set {
                _GestationalAgeCalculationMethodByEstimatedDateOfDelivery = value;
            }
        }
        public Field EstimatedDateOfDeliveryDate {
            get {
                return _EstimatedDateOfDeliveryDate;
            }
            private set {
                _EstimatedDateOfDeliveryDate = value;
            }
        }
        public Field TypeOfPregnancy {
            get {
                return _TypeOfPregnancy;
            }
            private set {
                _TypeOfPregnancy = value;
            }
        }
        public Field RoutineScreening {
            get {
                return _RoutineScreening;
            }
            private set {
                _RoutineScreening = value;
            }
        }
        public Field PreviousNeuralTubeDefects {
            get {
                return _PreviousNeuralTubeDefects;
            }
            private set {
                _PreviousNeuralTubeDefects = value;
            }
        }
        public Field AdvancedMaternalAge {
            get {
                return _AdvancedMaternalAge;
            }
            private set {
                _AdvancedMaternalAge = value;
            }
        }
        public Field HistoryOfDownSyndrome {
            get {
                return _HistoryOfDownSyndrome;
            }
            private set {
                _HistoryOfDownSyndrome = value;
            }
        }
        public Field HistoryOfCysticFibrosis {
            get {
                return _HistoryOfCysticFibrosis;
            }
            private set {
                _HistoryOfCysticFibrosis = value;
            }
        }
        public Field OtherIndications {
            get {
                return _OtherIndications;
            }
            private set {
                _OtherIndications = value;
            }
        }
        public Field HandWrittenAFPInfo {
            get {
                return _HandWrittenAFPInfo;
            }
            private set {
                _HandWrittenAFPInfo = value;
            }
        }
        public Field ReasonForRepeatElevated {
            get {
                return _ReasonForRepeatElevated;
            }
            private set {
                _ReasonForRepeatElevated = value;
            }
        }
        public Field EarlyGA {
            get {
                return _EarlyGA;
            }
            private set {
                _EarlyGA = value;
            }
        }
        public Field Hemolyzed {
            get {
                return _Hemolyzed;
            }
            private set {
                _Hemolyzed = value;
            }
        }

        public Field UltrasoundMeasurementCrownRumpLength {
            get { return _UltrasoundMeasurementCrownRumpLength; }
            set { _UltrasoundMeasurementCrownRumpLength = value; }
        }
        public Field UltrasoundMeasurementCrownRumpLengthDate {
            get { return _UltrasoundMeasurementCrownRumpLengthDate; }
            set { _UltrasoundMeasurementCrownRumpLengthDate = value; }
        }
        public Field UltrasoundMeasurementCrownRumpLengthForTwinB {
            get { return _UltrasoundMeasurementCrownRumpLengthForTwinB; }
            set { _UltrasoundMeasurementCrownRumpLengthForTwinB = value; }
        }
        public Field NuchalTranslucency {
            get { return _NuchalTranslucency; }
            set { _NuchalTranslucency = value; }
        }
        public Field NuchalTranslucencyForTwinB {
            get { return _NuchalTranslucencyForTwinB; }
            set { _NuchalTranslucencyForTwinB = value; }
        }
        public Field DonerEgg {
            get { return _DonerEgg; }
            set { _DonerEgg = value; }
        }
        public Field AgeOfEggDonor {
            get { return _AgeOfEggDonor; }
            set { _AgeOfEggDonor = value; }
        }
        public Field PriorDownSyndromeScreeningDuringCurrentPregnancy {
            get { return _PriorDownSyndromeScreeningDuringCurrentPregnancy; }
            set { _PriorDownSyndromeScreeningDuringCurrentPregnancy = value; }
        }
        public Field PriorFirstTrimesterTesting {
            get { return _PriorFirstTrimesterTesting; }
            set { _PriorFirstTrimesterTesting = value; }
        }
        public Field PriorSecondTrimesterTesting {
            get { return _PriorSecondTrimesterTesting; }
            set { _PriorSecondTrimesterTesting = value; }
        }
        public Field FamilyHistoryOfNeuralTubeDefects {
            get { return _FamilyHistoryOfNeuralTubeDefects; }
            set { _FamilyHistoryOfNeuralTubeDefects = value; }
        }
        public Field PriorPregnancyWithDownSyndrome {
            get { return _PriorPregnancyWithDownSyndrome; }
            set { _PriorPregnancyWithDownSyndrome = value; }
        }
        public Field ChorionictyMonochorionic {
            get { return _ChorionictyMonochorionic; }
            set { _ChorionictyMonochorionic = value; }
        }
        public Field ChorionictyDichorionic {
            get { return _ChorionictyDichorionic; }
            set { _ChorionictyDichorionic = value; }
        }
        public Field ChorionictyUnknown {
            get { return _ChorionictyUnknown; }
            set { _ChorionictyUnknown = value; }
        }
        public Field SonographerLastName {
            get { return _SonographerLastName; }
            set { _SonographerLastName = value; }
        }
        public Field SonographerFirstName {
            get { return _SonographerFirstName; }
            set { _SonographerFirstName = value; }
        }
        public Field SonographerIDNumber {
            get { return _SonographerIDNumber; }
            set { _SonographerIDNumber = value; }
        }
        public Field CredentialedByNTQR {
            get { return _CredentialedByNTQR; }
            set { _CredentialedByNTQR = value; }
        }
        public Field CredentialedByFMF {
            get { return _CredentialedByFMF; }
            set { _CredentialedByFMF = value; }
        }
        public Field CredentialedByOtherOrganization {
            get { return _CredentialedByOtherOrganization; }
            set { _CredentialedByOtherOrganization = value; }
        }
        public Field SiteNumber {
            get { return _SiteNumber; }
            set { _SiteNumber = value; }
        }
        public Field ReadingPhysicianID {
            get { return _ReadingPhysicianID; }
            set { _ReadingPhysicianID = value; }
        }

        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, InsulinDependent, GestationAgeWeeks, GestationalAgeDays, GestationalAgeDecimalForm, GestationalAgeDate, GestationalAgeCalculationMethodByLastMenstrualPeriod, LastMenstrualPeriodDate, GestationalAgeCalculationMethodByUltrasound, UltrasoundDate, GestationalAgeCalculationMethodByEstimatedDateOfDelivery, EstimatedDateOfDeliveryDate, TypeOfPregnancy, RoutineScreening, PreviousNeuralTubeDefects, AdvancedMaternalAge, HistoryOfDownSyndrome, HistoryOfCysticFibrosis, OtherIndications, HandWrittenAFPInfo, ReasonForRepeatElevated, EarlyGA, Hemolyzed, UltrasoundMeasurementCrownRumpLength, UltrasoundMeasurementCrownRumpLengthDate, UltrasoundMeasurementCrownRumpLengthForTwinB, NuchalTranslucency, NuchalTranslucencyForTwinB, DonerEgg, AgeOfEggDonor, PriorDownSyndromeScreeningDuringCurrentPregnancy, PriorFirstTrimesterTesting, PriorSecondTrimesterTesting, FamilyHistoryOfNeuralTubeDefects, ChorionictyMonochorionic, ChorionictyDichorionic, ChorionictyUnknown, SonographerLastName, SonographerFirstName, SonographerIDNumber, CredentialedByNTQR, CredentialedByFMF, CredentialedByOtherOrganization, SiteNumber, ReadingPhysicianID });
            }
        }
        public override string SegmentType {
            get {
                return "ZSA";
            }
        }
        public override string Title {
            get {
                return "Superm Alpha Feta Protein";
            }
        }
        #endregion
        #region Constructors
        public SuperAlphaFetaProteinSegment() {
            SegmentTypeID = new Field("Segment Type ID", "ZSA.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "ZSA");
            InsulinDependent = new Field("Insulin Dependent", "ZSA.2", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            GestationAgeWeeks = new Field("Gestation Age Weeks", "ZSA.3", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeDays = new Field("Gestational Age Days", "ZSA.3", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeDecimalForm = new Field("Gestational Age Decimal Form", "ZSA.3", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeDate = new Field("Gestational Age Date", "ZSA.3", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 8, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeCalculationMethodByLastMenstrualPeriod = new Field("Gestational Age Calculation Method by Last Menstrual Period ", "ZSA.4", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            LastMenstrualPeriodDate = new Field("Last Menstrual Period Date", "ZSA.4", "To provide relevant information pertaining to the order", RequiredFlags.Conditional, 8, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeCalculationMethodByUltrasound = new Field("Gestational Age Calculation Method by Ultrasound", "ZSA.5", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            UltrasoundDate = new Field("Ultrasound Date", "ZSA.5", "To provide relevant information pertaining to the order", RequiredFlags.Conditional, 8, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            GestationalAgeCalculationMethodByEstimatedDateOfDelivery = new Field("Gestational Age Calculation Method by Estimated Date of Delivery", "ZSA.6", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            EstimatedDateOfDeliveryDate = new Field("Estimated Date of Delivery Date", "ZSA.6", "To provide relevant information pertaining to the order", RequiredFlags.Conditional, 8, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            TypeOfPregnancy = new Field("Type of Pregnancy", "ZSA.7", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            RoutineScreening = new Field("Routine Screening ", "ZSA.8", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            PreviousNeuralTubeDefects = new Field("Previous Neural Tube Defects ", "ZSA.9", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            AdvancedMaternalAge = new Field("Advanced Maternal Age ", "ZSA.10", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            HistoryOfDownSyndrome = new Field("History of Down Syndrome", "ZSA.11", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            HistoryOfCysticFibrosis = new Field("History of Cystic Fibrosis", "ZSA.12", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            OtherIndications = new Field("Other Indications", "ZSA.13", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            HandWrittenAFPInfo = new Field("Hand Written AFP Info", "ZSA.14", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 20, string.Empty, SupportedCharacters.AlphaNumeric, 0, string.Empty);
            ReasonForRepeatElevated = new Field("Reason for Repeat: Elevated", "ZSA.15", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            EarlyGA = new Field("Early GA", "ZSA.16", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Hemolyzed = new Field("Hemolyzed", "ZSA.17", "To provide relevant information pertaining to the order", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            //extra fields will hopefully work (06/11/11)
        }
        public SuperAlphaFetaProteinSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field superAlphaFetaProtein in KnownFields) {
                superAlphaFetaProtein.Delimiter = fieldDelimiter;
            }
            foreach (Field superAlphaFetaProtein in new Field[] { GestationAgeWeeks, GestationalAgeDays, GestationalAgeDecimalForm, GestationalAgeCalculationMethodByLastMenstrualPeriod, GestationalAgeCalculationMethodByUltrasound, GestationalAgeCalculationMethodByEstimatedDateOfDelivery, UltrasoundMeasurementCrownRumpLength, UltrasoundMeasurementCrownRumpLengthDate, NuchalTranslucency, DonerEgg, ChorionictyDichorionic, ChorionictyMonochorionic, SonographerLastName, SonographerFirstName, SonographerIDNumber, CredentialedByNTQR, CredentialedByFMF }) {
                superAlphaFetaProtein.Delimiter = componentDelimiter;
            }
            //Last one is always a newline
            this.Hemolyzed.Delimiter = System.Environment.NewLine;
        }
        public SuperAlphaFetaProteinSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 17) {
                throw new ArgumentException("Not enough fields to construct a valid super alpha feta protein segment (ZSA).  Expected at least 17, returned " + fields.Count);
            }
            SegmentTypeID.Value = fields[0];
            InsulinDependent.Value = fields[1];
            if (fields[2].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZSA.3'");
            }
            List<string> components = new List<string>(fields[2].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count != 4) {
                throw new ArgumentException("Unexpected number of components returned for the field 'ZSA.3'.  Expected 4, returned " + components.Count);
            }
            GestationAgeWeeks.Value = components[0];
            GestationalAgeDays.Value = components[1];
            GestationalAgeDecimalForm.Value = components[2];
            GestationalAgeDate.Value = components[3];
            if (fields[3].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZSA.4'");
            }
            components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            if (components.Count != 2) {
                throw new ArgumentException("Unexpected number of components returned for the field 'ZSA.4'.  Expected 2, returned " + components.Count);
            }
            GestationalAgeCalculationMethodByLastMenstrualPeriod.Value = components[0];
            LastMenstrualPeriodDate.Value = components[1];
            if (fields[4].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZSA.5'");
            }
            components = new List<string>(fields[4].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            if (components.Count != 2) {
                throw new ArgumentException("Unexpected number of components returned for the field 'ZSA.5'.  Expected 2, returned " + components.Count);
            }
            GestationalAgeCalculationMethodByUltrasound.Value = components[0];
            UltrasoundDate.Value = components[1];
            if (fields[5].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ZSA.6'");
            }
            components = new List<string>(fields[5].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            if (components.Count != 2) {
                throw new ArgumentException("Unexpected number of components returned for the field 'ZSA.6'.  Expected 2, returned " + components.Count);
            }
            GestationalAgeCalculationMethodByEstimatedDateOfDelivery.Value = components[0];
            EstimatedDateOfDeliveryDate.Value = components[1];
            //back to non-nested
            TypeOfPregnancy.Value = fields[6];
            RoutineScreening.Value = fields[7];
            PreviousNeuralTubeDefects.Value = fields[8];
            AdvancedMaternalAge.Value = fields[9];
            HistoryOfDownSyndrome.Value = fields[10];
            HistoryOfCysticFibrosis.Value = fields[11];
            OtherIndications.Value = fields[12];
            HandWrittenAFPInfo.Value = fields[13];
            ReasonForRepeatElevated.Value = fields[14];
            EarlyGA.Value = fields[15];
            Hemolyzed.Value = fields[16];
            if (fields.Count >= 18) {
                components = new List<string>(fields[17].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components != null) {
                    if (components.Count > 0) { UltrasoundMeasurementCrownRumpLength.Value = components[0]; }
                    if (components.Count > 1) { UltrasoundMeasurementCrownRumpLengthDate.Value = components[1]; }
                    if (components.Count > 2) { UltrasoundMeasurementCrownRumpLengthForTwinB.Value = components[2]; }
                }
            }
            if (fields.Count >= 19) {
                components = new List<string>(fields[18].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components != null) {
                    if (components.Count > 0) { this.NuchalTranslucency.Value = components[0]; }
                    if (components.Count > 1) { this.NuchalTranslucencyForTwinB.Value = components[1]; }
                }
            }
            if (fields.Count >= 20) {
                components = new List<string>(fields[19].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components != null) {
                    if (components.Count > 0) { this.DonerEgg.Value = components[0]; }
                    if (components.Count > 1) { this.AgeOfEggDonor.Value = components[1]; }
                }
            }
            if (fields.Count >= 21) {
                this.PriorDownSyndromeScreeningDuringCurrentPregnancy.Value = fields[20];
            }
            if (fields.Count >= 22) {
                this.PriorFirstTrimesterTesting.Value = fields[21];
            }
            if (fields.Count >= 23) {
                this.PriorSecondTrimesterTesting.Value = fields[22];
            }
            if (fields.Count >= 24) {
                this.FamilyHistoryOfNeuralTubeDefects.Value = fields[23];
            }
            if (fields.Count >= 25) {
                this.PriorPregnancyWithDownSyndrome.Value = fields[24];
            }
            if (fields.Count >= 26) {
                components = new List<string>(fields[25].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components != null) {
                    if (components.Count > 0) { this.ChorionictyDichorionic.Value = components[0]; }
                    if (components.Count > 1) { this.ChorionictyMonochorionic.Value = components[1]; }
                    if (components.Count > 2) { this.ChorionictyUnknown.Value = components[2]; }
                }
            }
            if (fields.Count >= 27) {
                components = new List<string>(fields[26].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                if (components != null) {
                    if (components.Count > 0) { this._SonographerLastName.Value = components[0]; }
                    if (components.Count > 1) { this.SonographerFirstName.Value = components[1]; }
                    if (components.Count > 2) { this.SonographerIDNumber.Value = components[2]; }
                    if (components.Count > 3) { this.CredentialedByNTQR.Value = components[3]; }
                    if (components.Count > 4) { this.CredentialedByFMF.Value = components[4]; }
                    if (components.Count > 5) { this.CredentialedByOtherOrganization.Value = components[5]; }
                }
            }
            if (fields.Count >= 28) {
                this.SiteNumber.Value = fields[27];
            }
            if (fields.Count >= 29) {
                this.ReadingPhysicianID.Value = fields[28];
            }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 29) {
                for (int x = 29; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZSA." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        #endregion
    }
}
