using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class PatientVisitSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _PatientClass = new Field();
        private Field _AssignedPatientLocation = new Field();
        private Field _AdmissionType = new Field();
        private Field _PreAdmitNumber = new Field();
        private Field _PriorPatientLocation = new Field();
        private Field _PhysicianID = new Field();
        private Field _PhysicianLastName = new Field();
        private Field _PhysicianFirstInitial = new Field();
        private Field _PhysicianMiddleInitial = new Field();
        private Field _PhysicianSuffix = new Field();
        private Field _PhysicianPrefix = new Field();
        private Field _PhysicianDegree = new Field();
        private Field _SourceTable = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field PatientClass {
            get {
                return _PatientClass;
            }
            private set {
                _PatientClass = value;
            }
        }
        public Field AssignedPatientLocation {
            get {
                return _AssignedPatientLocation;
            }
            private set {
                _AssignedPatientLocation = value;
            }
        }
        public Field AdmissionType {
            get {
                return _AdmissionType;
            }
            private set {
                _AdmissionType = value;
            }
        }
        public Field PreAdmitNumber {
            get {
                return _PreAdmitNumber;
            }
            private set {
                _PreAdmitNumber = value;
            }
        }
        public Field PriorPatientLocation {
            get {
                return _PriorPatientLocation;
            }
            private set {
                _PriorPatientLocation = value;
            }
        }
        public Field PhysicianID {
            get {
                return _PhysicianID;
            }
            private set {
                _PhysicianID = value;
            }
        }
        public Field PhysicianLastName {
            get {
                return _PhysicianLastName;
            }
            private set {
                _PhysicianLastName = value;
            }
        }
        public Field PhysicianFirstInitial {
            get {
                return _PhysicianFirstInitial;
            }
            private set {
                _PhysicianFirstInitial = value;
            }
        }
        public Field PhysicianMiddleInitial {
            get {
                return _PhysicianMiddleInitial;
            }
            private set {
                _PhysicianMiddleInitial = value;
            }
        }
        public Field PhysicianSuffix {
            get {
                return _PhysicianSuffix;
            }
            private set {
                _PhysicianSuffix = value;
            }
        }
        public Field PhysicianPrefix {
            get {
                return _PhysicianPrefix;
            }
            private set {
                _PhysicianPrefix = value;
            }
        }
        public Field PhysicianDegree {
            get {
                return _PhysicianDegree;
            }
            private set {
                _PhysicianDegree = value;
            }
        }
        public Field SourceTable {
            get {
                return _SourceTable;
            }
            private set {
                _SourceTable = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, PatientClass, AssignedPatientLocation, AdmissionType, PreAdmitNumber, PriorPatientLocation, PhysicianID, PhysicianLastName, PhysicianFirstInitial, PhysicianMiddleInitial, PhysicianSuffix, PhysicianPrefix, PhysicianDegree, SourceTable });
            }
        }
        public override string SegmentType {
            get {
                return "PV1";
            }
        }
        public override string Title {
            get {
                return "Patient Visit";
            }
        }
        #endregion
        #region Constructors
        public PatientVisitSegment() {
            SegmentTypeID = new Field("	Segment Type ID", "PV1.1", "To identify the segment	", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaNumeric, 0, "PV1");
            SequenceNumber = new Field("Sequence Number", "	PV1.2", "", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 131, string.Empty);
            PatientClass = new Field("Patient Class", "	PV1.3", "Not currently saved, used, or returned	", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 132, string.Empty);
            AssignedPatientLocation = new Field("Assigned Patient Location", "	PV1.4", "Not currently saved, used, or returned	", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 133, string.Empty);
            AdmissionType = new Field("	Admission Type", "PV1.5", "", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 134, string.Empty);
            PreAdmitNumber = new Field("Pre-Admit Number", "PV1.6", "Not currently saved, used, or returned	", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 135, string.Empty);
            PriorPatientLocation = new Field("	Prior Patient Location", "PV1.7", "Not currently saved, used, or returned	", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 136, string.Empty);
            PhysicianID = new Field("Physician ID", "PV1.8", "", RequiredFlags.AlwaysRequired, 10, string.Empty, SupportedCharacters.AlphaNumericSpecial, 137, string.Empty);
            PhysicianLastName = new Field("	Physician Last Name	", "PV1.8", "", RequiredFlags.AlwaysRequired, 9, string.Empty, SupportedCharacters.AlphaOnly, 137, string.Empty);
            PhysicianFirstInitial = new Field("Physician First Initial", "PV1.8", "", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.AlphaOnly, 137, string.Empty);
            PhysicianMiddleInitial = new Field("Physician Middle Initial", "PV1.8", "", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.AlphaOnly, 137, string.Empty);
            PhysicianSuffix = new Field("Physician Suffix", "PV1.8	", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 137, string.Empty);
            PhysicianPrefix = new Field("Physician Prefix", "PV1.8	", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 137, string.Empty);
            PhysicianDegree = new Field("Physician Degree", "PV1.8	", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 137, string.Empty);
            SourceTable = new Field("Source Table", "PV1.8	", "Required for certain types of billing", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 137, string.Empty);
        }
        public PatientVisitSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 1) {
                throw new ArgumentException("Not enough fields to construct a valid patient visit segment (PV1).  Expected at least 1, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            if (fields.Count > 1)
                this.SequenceNumber.Value = fields[1];
            if (fields.Count > 2)
                this.PatientClass.Value = fields[2];
            if (fields.Count > 3)
                this.AssignedPatientLocation.Value = fields[3];
            if (fields.Count > 4)
                this.AdmissionType.Value = fields[4];
            if (fields.Count > 5)
                this.PreAdmitNumber.Value = fields[5];
            if (fields.Count > 6)
            this.PriorPatientLocation.Value = fields[6];

            if (fields.Count > 7) {
                List<string> components = new List<string>(fields[7].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter

                if (components.Count > 0)
                    this.PhysicianID.Value = components[0];
                if (components.Count > 1)
                    this.PhysicianLastName.Value = components[1];
                if (components.Count > 2) 
                this.PhysicianFirstInitial.Value = components[2];
                if (components.Count > 3) 
                    this.PhysicianMiddleInitial.Value = components[3];
                if (components.Count > 4) 
                    this.PhysicianSuffix.Value = components[4];
                if (components.Count > 5) 
                    this.PhysicianPrefix.Value = components[5];
                if (components.Count > 6) 
                    this.PhysicianDegree.Value = components[6];
                if (components.Count > 7) 
                    this.SourceTable.Value = components[7];
            }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 8) {
                for (int x = 8; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "PV1." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public PatientVisitSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public PatientVisitSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field patientVisit in KnownFields) {
                patientVisit.Delimiter = fieldDelimiter;
            }
            //Nested field delimiters
            foreach (Field patientVisit in new Field[] { PhysicianID, PhysicianLastName, PhysicianFirstInitial, PhysicianMiddleInitial, PhysicianSuffix, PhysicianPrefix, PhysicianDegree }) {
                patientVisit.Delimiter = componentDelimiter;
            }
            //last delimiter is always a newline
            this.SourceTable.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
