using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    //This was implemented for Boswik & Quest Labratories.
    //They used a differnt numbering scheme for the nmenomic, they start from 0, Labcorp started from 1
    public class MessageAcknowledgementSegment : Segment {
        #region Private Instance Variables
        private Field _AcknowledgmentCode = new Field();
        private Field _MessageControlID = new Field();
        private Field _TextMessage = new Field();
        private Field _ExpectedSequenceNumber = new Field();
        private Field _DelayedAcknowledgementType = new Field();
        private Field _ErrorCondition = new Field();
        #endregion
        #region Public Instance Properties
        public Field AcknowledgmentCode {
            get {
                return _AcknowledgmentCode;
            }
            private set {
                _AcknowledgmentCode = value;
            }
        }
        public Field MessageControlID {
            get {
                return _MessageControlID;
            }
            private set {
                _MessageControlID = value;
            }
        }
        public Field TextMessage {
            get {
                return _TextMessage;
            }
            private set {
                _TextMessage = value;
            }
        }
        public Field ExpectedSequenceNumber {
            get {
                return _ExpectedSequenceNumber;
            }
            private set {
                _ExpectedSequenceNumber = value;
            }
        }
        public Field DelayedAcknowledgementType {
            get {
                return _DelayedAcknowledgementType;
            }
            private set {
                _DelayedAcknowledgementType = value;
            }
        }
        public Field ErrorCondition {
            get {
                return _ErrorCondition;
            }
            private set {
                _ErrorCondition = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, AcknowledgmentCode, MessageControlID, TextMessage, ExpectedSequenceNumber, DelayedAcknowledgementType, ErrorCondition });
            }
        }
        #endregion
        #region Constructors
        public MessageAcknowledgementSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "MSA.0", "To identify the segment", RequiredFlags.Optional, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, this.SegmentType);
            this.AcknowledgmentCode = new Field("Acknowledgment Code", "MSA.1", "ACK Code", RequiredFlags.Optional, 2, string.Empty, SupportedCharacters.AlphaOnly, 18, string.Empty);
            this.MessageControlID = new Field("Message Control ID", "MSA.2", "Identify the matching order message", RequiredFlags.Optional, 20, string.Empty, SupportedCharacters.AlphaNumeric, 10, string.Empty);
            this.TextMessage = new Field("Text Message", "MSA.3", "Not currently used", RequiredFlags.Unused, 80, string.Empty, SupportedCharacters.Unused, 20, string.Empty);
            this.ExpectedSequenceNumber = new Field("Expected Sequence Number", "MSA.4", "Not currently used", RequiredFlags.Unused, 15, string.Empty, SupportedCharacters.Unused, 21, string.Empty);
            this.DelayedAcknowledgementType = new Field("Delayed Acknowledgement Type", "MSA.5", "Not currently used", RequiredFlags.Unused, 1, string.Empty, SupportedCharacters.Unused, 22, string.Empty);
            this.ErrorCondition = new Field("Error Condition", "MSA.6", "Not currently used", RequiredFlags.Unused, 100, string.Empty, SupportedCharacters.Unused, 23, string.Empty);
        }
        public MessageAcknowledgementSegment(string fieldDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field field in KnownFields) {
                field.Delimiter = fieldDelimiter;
            }
        }
        public MessageAcknowledgementSegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 2) {
                throw new ArgumentException("Not enough fields to construct a valid message acknowledgement segment (MSA).  Expected at least 3, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.AcknowledgmentCode.Value = fields[1];
            this.MessageControlID.Value = fields[2];
            if (fields.Count >= 4) { this.TextMessage.Value = fields[3]; }
            if (fields.Count >= 5) { this.ExpectedSequenceNumber.Value = fields[4]; }
            if (fields.Count >= 6) { this.DelayedAcknowledgementType.Value = fields[5]; }
            if (fields.Count >= 7) { this.ErrorCondition.Value = fields[6]; }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 7) {
                for (int x = 2; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "MSA." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        #endregion
        public override string SegmentType {
            get {
                return "MSA";
            }
        }
        public override string Title {
            get {
                return "Acknowledgement";
            }
        }
    }
}
