using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
namespace LabcorpReportHL7 {
    //Classes for reporting.  So I don't have to make illegable SQL 
    public class RequestTest {
        private string _Code = string.Empty;
        private string _Description = string.Empty;
        public RequestTest(string code, string description) {
            _Code = code ?? string.Empty;
            _Description = description ?? string.Empty;
            _Code = _Code.Trim();
            _Description = _Description.Trim();
        }
        public string Code {
            get { return _Code; }
            set { _Code = value ?? string.Empty; }
        }
        public string Description {
            get { return _Description; }
            set { _Description = value ?? string.Empty; }
        }
    }
    public class RequestMessage {
        //public RequestMessage(string specimenID):this(specimenID, 0) {
        //for backwards compat.  
        //specimen ids can be duplicated...FU labs that say it can be 25 chars, but it can only really be 8
        //}
        public RequestMessage(string specimenID, uint patientID) {
            this.SpecimenID = specimenID.Trim();
            uint orderTypeID = 0;
            string insuranceIDColumn = null;
            DataRow patient = null;
            DataRow physician = null;
            DataRow primary = null;
            DataRow secondary = null;
            DataRow tertiary = null;
            //for backwards compat.  
            //specimen ids can be duplicated...FU labs that say it can be 25 chars, but it can only really be 8
            if (patientID == 0) {
                orderTypeID = SupraClasses.SupraDatabase.Database.ExecuteScalar<uint>("SELECT OrderTypeID FROM patientorders WHERE patientorders.ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " LIMIT 1;");
                insuranceIDColumn = SupraClasses.SupraDatabase.Database.ExecuteScalar<string>("SELECT InsuranceCarrierColumn FROM ordertypes WHERE ID = " + orderTypeID + ";").Trim();
                patient = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT patients.ID, CONCAT_WS(', ', TRIM(LastName), TRIM(FirstName)) AS Patient, Address1, Address2, City, State, Zip, DateOfBirth, Gender, SocialSecurityNumber, HomePhone, Fasting, WorkersCompensation, CollectionDateTime, Diagnosis, BillTo FROM patients, patientorders  WHERE patients.ID = patientorders.PatientID AND ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " LIMIT 1;");
                physician = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT physicians.ID, PracticeName, CONCAT_WS(', ', TRIM(LastName), TRIM(FirstName)) AS Physician, LabCorpNumber, NPI, Address1, Address2, City, State, ZipCode, Phone, LabcorpMSH4 FROM physicians, practicedetails WHERE physicians.PracticeID = practicedetails.ID AND physicians.ID IN(SELECT PhysicianID FROM patientorders WHERE ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + ") LIMIT 1;");
                primary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 1 AND insuranceinformation.Deleted = false AND PatientID IN(SELECT PatientID FROM patientorders WHERE ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + ") LIMIT 1;");
                secondary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 2 AND insuranceinformation.Deleted = false AND PatientID IN(SELECT PatientID FROM patientorders WHERE ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + ") LIMIT 1;");
                tertiary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 3 AND insuranceinformation.Deleted = false AND PatientID IN(SELECT PatientID FROM patientorders WHERE ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + ") LIMIT 1;");
            } else {
                orderTypeID = SupraClasses.SupraDatabase.Database.ExecuteScalar<uint>("SELECT OrderTypeID FROM patientorders WHERE patientorders.PatientID = " + patientID + " AND ORC3 LIKE " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " LIMIT 1;");
                insuranceIDColumn = SupraClasses.SupraDatabase.Database.ExecuteScalar<string>("SELECT InsuranceCarrierColumn FROM ordertypes WHERE ID = " + orderTypeID + ";").Trim();
                patient = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT patients.ID, CONCAT_WS(', ', TRIM(LastName), TRIM(FirstName)) AS Patient, Address1, Address2, City, State, Zip, DateOfBirth, Gender, SocialSecurityNumber, HomePhone, Fasting, WorkersCompensation, CollectionDateTime, Diagnosis, BillTo FROM patients, patientorders  WHERE patients.ID = patientorders.PatientID AND patientorders.PatientID = " + patientID + " AND ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " LIMIT 1;");
                physician = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT physicians.ID, PracticeName, CONCAT_WS(', ', TRIM(LastName), TRIM(FirstName)) AS Physician, LabCorpNumber, NPI, Address1, Address2, City, State, ZipCode, Phone, LabcorpMSH4 FROM physicians, practicedetails WHERE physicians.PracticeID = practicedetails.ID AND physicians.ID IN(SELECT PhysicianID FROM patientorders WHERE patientorders.PatientID = " + patientID + " AND ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + ") LIMIT 1;");
                primary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 1 AND insuranceinformation.Deleted = false AND PatientID = " + patientID + " LIMIT 1;");
                secondary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 2 AND insuranceinformation.Deleted = false AND PatientID = " + patientID + " LIMIT 1;");
                tertiary = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT " + insuranceIDColumn + ", GurantorID, MedicarePayer, Relationship, GroupID, GroupEmployerName, PlanID, MemberID, ShortName, InsuranceCarrierAddressID FROM insuranceinformation, insurancecarrier WHERE insuranceinformation.InsuranceCarrierID = insurancecarrier.ID AND insurancetype = 3 AND insuranceinformation.Deleted = false AND PatientID = " + patientID + " LIMIT 1;");
            }
            string labTable = SupraClasses.SupraDatabase.Database.ExecuteScalar<string>("SELECT OrdersTable FROM ordertypes WHERE ID = " + orderTypeID + ";").Trim();
            DataTable labs = null;
            if (patientID == 0) {
                labs = SupraClasses.SupraDatabase.Database.GetDataTable("SELECT Code, Description, HasQuestions, ProcClass, QuestionHL7, TotalVolume, Race, Weight, LabNote, SupressQuestionSegments FROM " + labTable + ", patientorders WHERE " + labTable + ".ID = patientorders.OrderID AND patientorders.ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " ORDER BY Code, Description;");
            } else {
                labs = SupraClasses.SupraDatabase.Database.GetDataTable("SELECT Code, Description, HasQuestions, ProcClass, QuestionHL7, TotalVolume, Race, Weight, LabNote, SupressQuestionSegments FROM " + labTable + ", patientorders WHERE " + labTable + ".ID = patientorders.OrderID AND patientorders.PatientID = " + patientID + " AND ORC3 = " + SupraClasses.SupraDatabase.Database.DelimitedString(specimenID) + " ORDER BY Code, Description;");
            }
            uint physicianID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(physician["ID"]);
            string otherLabAccountID = SupraClasses.SupraDatabase.Database.ExecuteScalar<string>("SELECT Value FROM ordertypemap WHERE SegmentType = 'MSH' AND OrderTypeID = " + orderTypeID + " AND FieldOrdinal = 4 AND PracticeID IN(SELECT PracticeID FROM physicians WHERE ID = " + physicianID + ");").Trim();

            #region Client
            this.ClientAccountNumber = otherLabAccountID.Length > 0 ? otherLabAccountID : SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["LabCorpNumber"]).Trim();
            this.ClientName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["PracticeName"]).Trim();
            this.ClientAddress = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["Address1"]).Trim() + SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["Address2"]).Trim();
            this.ClientCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["City"]).Trim();
            this.ClientState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["State"]).Trim();
            this.ClientZip = Formatter.FormatZipCode(SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["ZipCode"]).Trim());
            this.ClientPhone = Formatter.FormatPhoneNumber(SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["Phone"]).Trim());
            #endregion
            #region Patient
            this.PatientID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(patient["ID"]);
            this.AlternatePatientID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(patient["ID"]).ToString();
            this.PatientName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Patient"]).Trim();
            this.PatientGender = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Gender"]).Trim().ToUpper();
            this.PatientDateOfBirth = SupraClasses.DatabaseHelper.RemoveDBNull<DateTime>(patient["DateOfBirth"]).ToString("MM/dd/yyyy");
            this.PatientPhone = Formatter.FormatPhoneNumber(SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["HomePhone"]).Trim());
            this.PatientSSN = Formatter.FormatSocialSecurityNumber(SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["SocialSecurityNumber"]).Trim());
            if (PatientSSN.Length == 11) { PatientSSN = "***-**-" + PatientSSN.Substring(PatientSSN.Length - 4, 4); }
            this.PatientFasting = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(patient["Fasting"]) ? "Y" : "N";
            #endregion
            this.CollectionDate = SupraClasses.DatabaseHelper.RemoveDBNull<DateTime>(patient["CollectionDateTime"]).ToString("MM/dd/yyyy");
            this.CollectionTime = SupraClasses.DatabaseHelper.RemoveDBNull<DateTime>(patient["CollectionDateTime"]).ToString("HH:mm:ss tt");
            #region Physician
            this.PhysicianID = physicianID;
            this.PhysicianName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["Physician"]).Trim();
            this.PhysicianNPI = SupraClasses.DatabaseHelper.RemoveDBNull<string>(physician["NPI"]).Trim();
            #endregion
            #region Tests
            foreach (DataRow row in labs.Rows) {
                string code = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["Code"]).Trim();
                string description = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["Description"]).Trim();
                bool questions = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(row["HasQuestions"]);
                //An order can have questions, but not answered at physician office if the specimen isn't collected there.
                bool supress = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(row["SupressQuestionSegments"]);
                uint totalVolume = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(row["TotalVolume"]);
                string labNote = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["LabNote"]).Trim();
                //if (!string.IsNullOrEmpty(labNote) && labNote != this.LabNote) { this.LabNote += labNote + Environment.NewLine; }
                //can only have one afp/bl/cy per report
                bool afpLoaded = false;
                bool blLoaded = false;
                bool cyLoaded = false;
                if (totalVolume > 0 && TotalVolume != totalVolume.ToString()) { TotalVolume = totalVolume.ToString(); }
                if (questions && !supress) {
                    string procedureClass = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["ProcClass"]).Trim().ToUpper();
                    string hl7 = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["QuestionHL7"]).Trim();
                    switch (procedureClass) {
                        case "RI"://Alpha Fetal Protien
                            if (afpLoaded) { break; }
                            string race = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["Race"]).Trim().ToUpper();
                            ushort weight = SupraClasses.DatabaseHelper.RemoveDBNull<ushort>(row["Weight"]);
                            HL7.SuperAlphaFetaProteinSegment afp = new HL7.SuperAlphaFetaProteinSegment(hl7, "|", "^");
                            this.AFP_AdvancedMaternalAge = afp.AdvancedMaternalAge.Value.Trim().ToUpper();
                            this.AFP_ByEDD = afp.GestationalAgeCalculationMethodByEstimatedDateOfDelivery.Value.Trim().ToUpper();
                            this.AFP_ByEddDate = afp.EstimatedDateOfDeliveryDate.Value.Trim();
                            this.AFP_ByLMP = afp.GestationalAgeCalculationMethodByLastMenstrualPeriod.Value.Trim().ToUpper();
                            this.AFP_ByLMPDate = afp.LastMenstrualPeriodDate.Value.Trim();
                            this.AFP_ByUS = afp.GestationalAgeCalculationMethodByUltrasound.Value.Trim().ToUpper();
                            this.AFP_ByUSDate = afp.UltrasoundDate.Value.Trim();
                            this.AFP_Comment = afp.HandWrittenAFPInfo.Value.Trim().ToUpper();
                            this.AFP_EarlyGA = afp.EarlyGA.Value.Trim().ToUpper();
                            this.AFP_Elevated = afp.ReasonForRepeatElevated.Value.Trim().ToUpper();
                            this.AFP_GestationalAge = afp.GestationAgeWeeks.Value.Trim() + " Weeks, " + afp.GestationalAgeDays.Value.Trim() + " days";
                            this.AFP_GestationalAgeDate = afp.GestationalAgeDate.Value.Trim().ToUpper();
                            this.AFP_Hemolyzed = afp.Hemolyzed.Value.Trim().ToUpper();
                            this.AFP_HistoryOfCysticFibrosis = afp.HistoryOfCysticFibrosis.Value.Trim().ToUpper();
                            this.AFP_HistoryOfDownSyndrome = afp.HistoryOfDownSyndrome.Value.Trim().ToUpper();
                            this.AFP_InsulinDependent = afp.InsulinDependent.Value.Trim().ToUpper();
                            this.AFP_OtherIndications = afp.OtherIndications.Value.Trim().ToUpper();
                            this.AFP_PatientRace = race;
                            this.AFP_PatientWeight = weight.ToString() + " lbs";
                            this.AFP_PreviousNeuralTubeDefect = afp.PreviousNeuralTubeDefects.Value.Trim().ToUpper();
                            this.AFP_RoutineScreening = afp.RoutineScreening.Value.Trim().ToUpper();
                            this.AFP_TypeOfPregnancy = afp.TypeOfPregnancy.Value.Trim().ToUpper();
                            afpLoaded = true;
                            this.ShowAFP = true;
                            break;
                        case "TX"://Blood Lead
                            if (blLoaded) { break; }
                            HL7.BloodLeadSegment bl = new HL7.BloodLeadSegment(hl7, "|");
                            this.BloodLeadRace = bl.PatientRace.Value.Trim().ToUpper();
                            this.BloodLeadType = bl.BloodLeadType.Value.Trim().ToUpper();
                            this.BloodLeadHispanic = bl.Hispanic.Value.Trim().ToUpper();
                            this.BloodLeadPurpose = bl.BloodLeadPurpose.Value.Trim().ToUpper();
                            blLoaded = true;
                            this.ShowBloodLead = true;
                            break;
                        case "CY"://Cytology
                            if (cyLoaded) { break; }
                            HL7.BethesdaCytologySegment cy = new HL7.BethesdaCytologySegment(hl7, "|");
                            if (cy.SwabSpatula.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Swab/Spatula";
                            } else if (cy.BrushSpatula.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Brush/Spatula";
                            } else if (cy.SpatulaAlone.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Spatula-Alone";
                            } else if (cy.BrushAlone.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Brush-Alone";
                            } else if (cy.BroomAlone.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Broom-Alone";
                            } else if (cy.OtherCollectionTechnique.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_CollectionTechnique = "Other";
                            }
                            DateTime tmp;
                            bool parsed = DateTime.TryParseExact(cy.LMPMenoDate.Value.Trim(), "yyyyMMdd", System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out tmp);
                            if (parsed) { this.Cytology_DateLMP_Menopause = tmp.ToString("MM/dd/yyyy"); }
                            if (cy.Cervical.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_GynSource = "Cervical";
                            } else if (cy.Endocervical.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_GynSource = "Endocervical";
                            } else if (cy.LabiaVulva.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_GynSource = "Labia/Vulva";
                            } else if (cy.Vaginal.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_GynSource = "Vaginal";
                            } else if (cy.Endometrial.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_GynSource = "Endometrial";
                            }
                            if (cy.Pregnant.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Pregnant";
                            } else if (cy.Lactating.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Lactating";
                            } else if (cy.OralContraceptives.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Oral Contraceptives";
                            } else if (cy.Menopausal.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Menopausal";
                            } else if (cy.EstroRX.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Estro-RX";
                            } else if (cy.PMPBleeding.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "PMP-Bleeding";
                            } else if (cy.PostPart.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "Post-Part";
                            } else if (cy.IUD.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "IUD";
                            } else if (cy.AllOtherPat.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_OtherPatientInformation = "All-Other-Pat";
                            }
                            if (cy.Negative.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "Negative";
                            } else if (cy.Atypical.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "Atypical";
                            } else if (cy.Dysplasia.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "Dysplasia";
                            } else if (cy.CaInSitu.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "CaInSitu";
                            } else if (cy.Invasive.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "Invasive";
                            } else if (cy.OtherPreviousInformation.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousCytology = "Other Previous Information";
                            }
                            if (cy.None.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "None";
                            } else if (cy.Hyst.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "Hyst";
                            } else if (cy.Coniza.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "Coniza";
                            } else if (cy.ColpBX.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "ColpBX";
                            } else if (cy.LaserVap.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "LaserVap";
                            } else if (cy.Cyro.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "Cyro";
                            } else if (cy.Radiation.Value.Trim().ToUpper() == "Y") {
                                this.Cytology_PreviousTreatment = "Radiation";
                            }
                            cyLoaded = true;
                            this.ShowCytology = true;
                            break;
                        case "MI"://Micro
                            string source = SupraClasses.DatabaseHelper.RemoveDBNull<string>(row["QuestionHL7"]).Trim();
                            if (hl7.Length > 0) {
                                if (!ShowSpecimenSource) { ShowSpecimenSource = true; }
                                SpecimenSource += hl7 + "; ";
                            }
                            break;
                        case "QUEST":
                        case "BOSTWICK":
                        case "SOLSTAS":
                            if (hl7.Length == 0) { break; }
                            string[] obxs = hl7.Split(new string[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries);
                            foreach (string obxString in obxs) {
                                HL7.ObservationResultSegment obx = new HL7.ObservationResultSegment(obxString, "|", "^");
                                this.LabNote += obx.SequenceNumber.Value + ". " + code + ": " + obx.ObservationText.Value + " " + obx.ObservationValue.Value + Environment.NewLine;
                            }
                            break;

                    }
                }
                RequestTest rt = new RequestTest(code, description);
                if (!string.IsNullOrEmpty(labNote)) { rt.Description += " - Notes: " + labNote; }
                this.RequestedTests.Add(rt);
            }
            if (SpecimenSource.EndsWith("; ")) { SpecimenSource = SpecimenSource.Remove(SpecimenSource.Length - 2, 2); }
            #endregion
            #region Diagnosis
            string[] diagnosis = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Diagnosis"]).Split(new string[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries);
            //Max of 8 allowed by labcorp
            int totalDiagnosis = diagnosis.Length <= 8 ? diagnosis.Length : 8;
            for (int x = 0; x <= totalDiagnosis - 1; x++) {
                switch (x) {
                    case 0:
                        this.DiagnosisCode1 = diagnosis[x];
                        break;
                    case 1:
                        this.DiagnosisCode2 = diagnosis[x];
                        break;
                    case 2:
                        this.DiagnosisCode3 = diagnosis[x];
                        break;
                    case 3:
                        this.DiagnosisCode4 = diagnosis[x];
                        break;
                    case 4:
                        this.DiagnosisCode5 = diagnosis[x];
                        break;
                    case 5:
                        this.DiagnosisCode6 = diagnosis[x];
                        break;
                    case 6:
                        this.DiagnosisCode7 = diagnosis[x];
                        break;
                    case 7:
                        this.DiagnosisCode8 = diagnosis[x];
                        break;
                }
            }
            #endregion
            string bill = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["BillTo"]).Trim().ToUpper();
            BillTo = bill;
            if (bill == "PRACTICE") { BillTo = "CLIENT"; }
            //Will show for patient/insurance billing, but not practice
            #region Insured/Responsible Information
            if (this.BillTo != "CLIENT") {
                this.ShowInsured = true;
                //We're assuming all insurances have the same gurantor
                uint gurantorID = 0;
                this.InsuredRelationship = "SELF";
                if (primary != null) {
                    gurantorID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(primary["GurantorID"]);
                    this.InsuredRelationship = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["Relationship"]).Trim().ToUpper();
                }
                if (this.InsuredRelationship == "SELF" || gurantorID == 0) {
                    this.InsuredName = this.PatientName;
                    this.InsuredAddress = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Address1"]).Trim() + SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Address2"]).Trim();
                    this.InsuredCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["City"]).Trim();
                    this.InsuredState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["State"]).Trim();
                    this.InsuredZip = Formatter.FormatZipCode(SupraClasses.DatabaseHelper.RemoveDBNull<string>(patient["Zip"]).Trim());
                } else {
                    //Labcorp only has self/spouse/other
                    //if (this.InsuredRelationship != "SPOUSE") { this.InsuredRelationship = "OTHER"; }
                    DataRow gurantor = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT CONCAT_WS(', ', TRIM(LastName), TRIM(FirstName)) AS Gurantor, Address1, Address2, City, State, ZipCode FROM gurantor WHERE ID = " + gurantorID + " LIMIT 1;");
                    this.InsuredName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["Gurantor"]).Trim();
                    this.InsuredAddress = SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["Address1"]).Trim() + SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["Address2"]).Trim();
                    this.InsuredCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["City"]).Trim();
                    this.InsuredState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["State"]).Trim();
                    this.InsuredZip = Formatter.FormatZipCode(SupraClasses.DatabaseHelper.RemoveDBNull<string>(gurantor["ZipCode"]).Trim());
                }
            } else {
                this.ShowInsured = false;
            }
            #endregion
            #region Insurance Information
            this.ShowPrimaryInsurance = false;
            this.ShowSecondaryInsurance = false;
            this.ShowTertiaryInsurance = false;
            if (BillTo == "INSURANCE") {
                if (primary != null) {
                    this.ShowPrimaryInsurance = true;
                    bool primaryMedicare = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(primary["MedicarePayer"]);
                    if (primaryMedicare) { BillTo = "MEDICARE"; }
                    this.PrimaryMedicareID = primaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["MemberID"]).Trim() : string.Empty;
                    this.PrimaryMemberID = !primaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["MemberID"]).Trim() : string.Empty;
                    this.PrimaryPlanID = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["PlanID"]).Trim();
                    this.PrimaryInsuranceName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["ShortName"]).Trim();
                    this.PrimaryGroupNumber = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary["GroupID"]).Trim();
                    this.PrimaryWorkersCompensation = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(patient["WorkersCompensation"]) ? "Y" : "N";
                    this.PrimaryPayorCarrierCode = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primary[insuranceIDColumn]).Trim();
                    uint primaryAddressID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(primary["InsuranceCarrierAddressID"]);
                    if (primaryAddressID > 0) {
                        DataRow primaryAddressRow = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT Address1, Address2, City, State, ZipCode FROM insurancecarrieraddress WHERE ID = " + primaryAddressID + ";");
                        this.PrimaryAddress = (SupraClasses.DatabaseHelper.RemoveDBNull<string>(primaryAddressRow["Address1"]).Trim() + " " + SupraClasses.DatabaseHelper.RemoveDBNull<string>(primaryAddressRow["Address2"]).Trim()).Trim();
                        this.PrimaryCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primaryAddressRow["City"]).Trim();
                        this.PrimaryState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primaryAddressRow["State"]).Trim();
                        this.PrimaryZip = SupraClasses.DatabaseHelper.RemoveDBNull<string>(primaryAddressRow["ZipCode"]).Trim();
                    }
                    if (secondary != null) {
                        this.ShowSecondaryInsurance = true;
                        bool secondaryMedicare = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(secondary["MedicarePayer"]);
                        this.SecondaryMedicareID = secondaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary["MemberID"]).Trim() : string.Empty;
                        this.SecondaryMemberID = !secondaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary["MemberID"]).Trim() : string.Empty;
                        this.SecondaryPlanID = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary["PlanID"]).Trim();
                        this.SecondaryInsuranceName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary["ShortName"]).Trim();
                        this.SecondaryGroupNumber = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary["GroupID"]).Trim();
                        this.SecondaryWorkersCompensation = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(patient["WorkersCompensation"]) ? "Y" : "N";
                        this.SecondaryPayorCarrierCode = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondary[insuranceIDColumn]).Trim();
                        uint secondaryAddressID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(secondary["InsuranceCarrierAddressID"]);
                        if (secondaryAddressID > 0) {
                            DataRow secondaryAddressRow = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT Address1, Address2, City, State, ZipCode FROM insurancecarrieraddress WHERE ID = " + secondaryAddressID + ";");
                            this.SecondaryAddress = (SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondaryAddressRow["Address1"]).Trim() + " " + SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondaryAddressRow["Address2"]).Trim()).Trim();
                            this.SecondaryCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondaryAddressRow["City"]).Trim();
                            this.SecondaryState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondaryAddressRow["State"]).Trim();
                            this.SecondaryZip = SupraClasses.DatabaseHelper.RemoveDBNull<string>(secondaryAddressRow["ZipCode"]).Trim();
                        }
                        if (tertiary != null) {
                            this.ShowTertiaryInsurance = true;
                            bool tertiaryMedicare = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(tertiary["MedicarePayer"]);
                            this.TertiaryMedicareID = tertiaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary["MemberID"]).Trim() : string.Empty;
                            this.TertiaryMemberID = !tertiaryMedicare ? SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary["MemberID"]).Trim() : string.Empty;
                            this.TertiaryPlanID = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary["PlanID"]).Trim();
                            this.TertiaryInsuranceName = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary["ShortName"]).Trim();
                            this.TertiaryGroupNumber = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary["GroupID"]).Trim();
                            this.TertiaryWorkersCompensation = SupraClasses.DatabaseHelper.RemoveDBNull<bool>(patient["WorkersCompensation"]) ? "Y" : "N";
                            this.TertiaryPayorCarrierCode = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiary[insuranceIDColumn]).Trim();
                            uint tertiaryAddressID = SupraClasses.DatabaseHelper.RemoveDBNull<uint>(tertiary["InsuranceCarrierAddressID"]);
                            if (tertiaryAddressID > 0) {
                                DataRow tertiaryAddressRow = SupraClasses.SupraDatabase.Database.ExecuteDataRowScalar("SELECT Address1, Address2, City, State, ZipCode FROM insurancecarrieraddress WHERE ID = " + tertiaryAddressID + ";");
                                this.TertiaryAddress = (SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiaryAddressRow["Address1"]).Trim() + " " + SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiaryAddressRow["Address2"]).Trim()).Trim();
                                this.TertiaryCity = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiaryAddressRow["City"]).Trim();
                                this.TertiaryState = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiaryAddressRow["State"]).Trim();
                                this.TertiaryZip = SupraClasses.DatabaseHelper.RemoveDBNull<string>(tertiaryAddressRow["ZipCode"]).Trim();
                            }
                        }
                    }
                }
            }
            #endregion
        }
        #region Private Instance Fields
        private string _ClientAccountNumber = string.Empty;
        private string _ClientName = string.Empty;
        private string _ClientAddress = string.Empty;
        private string _ClientCity = string.Empty;
        private string _ClientState = string.Empty;
        private string _ClientZip = string.Empty;
        private string _ClientPhone = string.Empty;
        private string _SpecimenID = string.Empty;
        private string _SpecimenSource = string.Empty;//One per test in theory, but on the report it's 1 line
        private bool _ShowSpecimenSource = false;
        private string _LabNote = string.Empty;
        private string _AlternateSpecimenID = string.Empty;
        private string _PatientName = string.Empty;
        private string _PatientGender = string.Empty;
        private string _PatientDateOfBirth = string.Empty;
        private string _PatientSSN = string.Empty;
        private uint _PatientID = 0;
        private string _AlternatePatientID = string.Empty;
        private string _PatientPhone = string.Empty;
        private string _PatientFasting = string.Empty;
        private string _CollectionDate = string.Empty;
        private string _CollectionTime = string.Empty;
        private string _PhysicianNPI = string.Empty;
        private uint _PhysicianID = 0;
        private string _AlternatePhysicianID = string.Empty;
        private string _PhysicianName = string.Empty;
        private string _BillTo = string.Empty;
        private string _TotalVolume = string.Empty;
        private List<RequestTest> _RequestedTests = new List<RequestTest>();
        private string _DiagnosisCode1 = string.Empty;
        private string _DiagnosisCode2 = string.Empty;
        private string _DiagnosisCode3 = string.Empty;
        private string _DiagnosisCode4 = string.Empty;
        private string _DiagnosisCode5 = string.Empty;
        private string _DiagnosisCode6 = string.Empty;
        private string _DiagnosisCode7 = string.Empty;
        private string _DiagnosisCode8 = string.Empty;
        private bool _ShowInsured = false;
        private string _InsuredName = string.Empty;
        private string _InsuredAddress = string.Empty;
        private string _InsuredCity = string.Empty;
        private string _InsuredState = string.Empty;
        private string _InsuredZip = string.Empty;
        private string _InsuredRelationship = string.Empty;
        private bool _ShowPrimaryInsurance = false;
        private string _PrimaryMedicareID = string.Empty;
        private string _PrimaryInsuranceName = string.Empty;
        private string _PrimaryMemberID = string.Empty;
        private string _PrimaryPlanID = string.Empty;
        private string _PrimaryGroupNumber = string.Empty;
        private string _PrimaryAddress = string.Empty;
        private string _PrimaryCity = string.Empty;
        private string _PrimaryState = string.Empty;
        private string _PrimaryZip = string.Empty;
        private string _PrimaryWorkersCompensation = "N";
        private string _PrimaryPayorCarrierCode = string.Empty;
        private bool _ShowSecondaryInsurance = false;
        private string _SecondaryMedicareID = string.Empty;
        private string _SecondaryInsuranceName = string.Empty;
        private string _SecondaryMemberID = string.Empty;
        private string _SecondaryPlanID = string.Empty;
        private string _SecondaryGroupNumber = string.Empty;
        private string _SecondaryAddress = string.Empty;
        private string _SecondaryCity = string.Empty;
        private string _SecondaryState = string.Empty;
        private string _SecondaryZip = string.Empty;
        private string _SecondaryWorkersCompensation = "N";
        private string _SecondaryPayorCarrierCode = string.Empty;
        private bool _ShowTertiaryInsurance = false;
        private string _TertiaryMedicareID = string.Empty;
        private string _TertiaryInsuranceName = string.Empty;
        private string _TertiaryMemberID = string.Empty;
        private string _TertiaryPlanID = string.Empty;
        private string _TertiaryGroupNumber = string.Empty;
        private string _TertiaryAddress = string.Empty;
        private string _TertiaryCity = string.Empty;
        private string _TertiaryState = string.Empty;
        private string _TertiaryZip = string.Empty;
        private string _TertiaryWorkersCompensation = "N";
        private string _TertiaryPayorCarrierCode = string.Empty;
        private bool _ShowAFP = false;
        private string _AFP_GestationalAge = string.Empty;
        private string _AFP_GestationalAgeDate = string.Empty;
        private string _AFP_ByLMP = string.Empty;
        private string _AFP_ByLMPDate = string.Empty;
        private string _AFP_ByUS = string.Empty;
        private string _AFP_ByUSDate = string.Empty;
        private string _AFP_ByEDD = string.Empty;
        private string _AFP_ByEddDate = string.Empty;
        private string _AFP_PatientWeight = string.Empty;
        private string _AFP_TypeOfPregnancy = string.Empty;
        private string _AFP_InsulinDependent = string.Empty;
        private string _AFP_PatientRace = string.Empty;
        private string _AFP_RoutineScreening = string.Empty;
        private string _AFP_PreviousNeuralTubeDefect = string.Empty;
        private string _AFP_AdvancedMaternalAge = string.Empty;
        private string _AFP_HistoryOfDownSyndrome = string.Empty;
        private string _AFP_HistoryOfCysticFibrosis = string.Empty;
        private string _AFP_OtherIndications = string.Empty;
        private string _AFP_Comment = string.Empty;
        private string _AFP_Elevated = string.Empty;
        private string _AFP_EarlyGA = string.Empty;
        private string _AFP_Hemolyzed = string.Empty;
        private bool _ShowCytology = false;
        private string _Cytology_GynSource = string.Empty;
        private string _Cytology_DateLMP_Menopause = string.Empty;
        private string _Cytology_CollectionTechnique = string.Empty;
        private string _Cytology_PreviousTreatment = string.Empty;
        private string _Cytology_PreviousCytology = string.Empty;
        private string _Cytology_OtherPatientInformation = string.Empty;
        private bool _ShowBloodLead = false;
        private string _BloodLeadRace = string.Empty;
        private string _BloodLeadType = string.Empty;
        private string _BloodLeadHispanic = string.Empty;
        private string _BloodLeadPurpose = string.Empty;
        #endregion
        #region Public Instance Properties
        public string ClientAccountNumber {
            get { return _ClientAccountNumber; }
            set { _ClientAccountNumber = value; }
        }
        public string ClientName {
            get { return _ClientName; }
            set { _ClientName = value; }
        }
        public string ClientAddress {
            get { return _ClientAddress; }
            set { _ClientAddress = value; }
        }
        public string ClientCity {
            get { return _ClientCity; }
            set { _ClientCity = value; }
        }
        public string ClientState {
            get { return _ClientState; }
            set { _ClientState = value; }
        }
        public string ClientZip {
            get { return _ClientZip; }
            set { _ClientZip = value; }
        }
        public string ClientPhone {
            get { return _ClientPhone; }
            set { _ClientPhone = value; }
        }
        public string SpecimenID {
            get { return _SpecimenID; }
            set { _SpecimenID = value; }
        }
        public string SpecimenSource {
            get { return _SpecimenSource; }
            set { _SpecimenSource = value; }
        }
        public bool ShowSpecimenSource {
            get { return _ShowSpecimenSource; }
            set { _ShowSpecimenSource = value; }
        }
        public string LabNote {
            get { return _LabNote; }
            set { _LabNote = value; }
        }
        public string AlternateSpecimenID {
            get { return _AlternateSpecimenID; }
            set { _AlternateSpecimenID = value; }
        }
        public string PatientName {
            get { return _PatientName; }
            set { _PatientName = value; }
        }
        public string PatientGender {
            get { return _PatientGender; }
            set { _PatientGender = value; }
        }
        public string PatientDateOfBirth {
            get { return _PatientDateOfBirth; }
            set { _PatientDateOfBirth = value; }
        }
        public string PatientSSN {
            get { return _PatientSSN; }
            set { _PatientSSN = value; }
        }
        public uint PatientID {
            get { return _PatientID; }
            set { _PatientID = value; }
        }
        public string AlternatePatientID {
            get { return _AlternatePatientID; }
            set { _AlternatePatientID = value; }
        }
        public string PatientPhone {
            get { return _PatientPhone; }
            set { _PatientPhone = value; }
        }
        public string PatientFasting {
            get { return _PatientFasting; }
            set { _PatientFasting = value; }
        }
        public string CollectionDate {
            get { return _CollectionDate; }
            set { _CollectionDate = value; }
        }
        public string CollectionTime {
            get { return _CollectionTime; }
            set { _CollectionTime = value; }
        }
        public string PhysicianNPI {
            get { return _PhysicianNPI; }
            set { _PhysicianNPI = value; }
        }
        public uint PhysicianID {
            get { return _PhysicianID; }
            set { _PhysicianID = value; }
        }
        public string AlternatePhysicianID {
            get { return _AlternatePhysicianID; }
            set { _AlternatePhysicianID = value; }
        }
        public string PhysicianName {
            get { return _PhysicianName; }
            set { _PhysicianName = value; }
        }
        public string BillTo {
            get { return _BillTo; }
            set { _BillTo = value; }
        }
        public string TotalVolume {
            get { return _TotalVolume; }
            set { _TotalVolume = value; }
        }
        public List<RequestTest> RequestedTests {
            get { return _RequestedTests; }
            set { _RequestedTests = value; }
        }
        public string DiagnosisCode1 {
            get { return _DiagnosisCode1; }
            set { _DiagnosisCode1 = value; }
        }
        public string DiagnosisCode2 {
            get { return _DiagnosisCode2; }
            set { _DiagnosisCode2 = value; }
        }
        public string DiagnosisCode3 {
            get { return _DiagnosisCode3; }
            set { _DiagnosisCode3 = value; }
        }
        public string DiagnosisCode4 {
            get { return _DiagnosisCode4; }
            set { _DiagnosisCode4 = value; }
        }
        public string DiagnosisCode5 {
            get { return _DiagnosisCode5; }
            set { _DiagnosisCode5 = value; }
        }
        public string DiagnosisCode6 {
            get { return _DiagnosisCode6; }
            set { _DiagnosisCode6 = value; }
        }
        public string DiagnosisCode7 {
            get { return _DiagnosisCode7; }
            set { _DiagnosisCode7 = value; }
        }
        public string DiagnosisCode8 {
            get { return _DiagnosisCode8; }
            set { _DiagnosisCode8 = value; }
        }
        public bool ShowInsured {
            get { return _ShowInsured; }
            set { _ShowInsured = value; }
        }
        public string InsuredName {
            get { return _InsuredName; }
            set { _InsuredName = value; }
        }
        public string InsuredAddress {
            get { return _InsuredAddress; }
            set { _InsuredAddress = value; }
        }
        public string InsuredCity {
            get { return _InsuredCity; }
            set { _InsuredCity = value; }
        }
        public string InsuredState {
            get { return _InsuredState; }
            set { _InsuredState = value; }
        }
        public string InsuredZip {
            get { return _InsuredZip; }
            set { _InsuredZip = value; }
        }
        public string InsuredRelationship {
            get { return _InsuredRelationship; }
            set { _InsuredRelationship = value; }
        }
        public bool ShowPrimaryInsurance {
            get { return _ShowPrimaryInsurance; }
            set { _ShowPrimaryInsurance = value; }
        }
        public string PrimaryMedicareID {
            get { return _PrimaryMedicareID; }
            set { _PrimaryMedicareID = value; }
        }
        public string PrimaryInsuranceName {
            get { return _PrimaryInsuranceName; }
            set { _PrimaryInsuranceName = value; }
        }
        public string PrimaryMemberID {
            get { return _PrimaryMemberID; }
            set { _PrimaryMemberID = value; }
        }
        public string PrimaryPlanID {
            get { return _PrimaryPlanID; }
            set { _PrimaryPlanID = value; }
        }
        public string PrimaryGroupNumber {
            get { return _PrimaryGroupNumber; }
            set { _PrimaryGroupNumber = value; }
        }
        public string PrimaryAddress {
            get { return _PrimaryAddress; }
            set { _PrimaryAddress = value; }
        }
        public string PrimaryCity {
            get { return _PrimaryCity; }
            set { _PrimaryCity = value; }
        }
        public string PrimaryState {
            get { return _PrimaryState; }
            set { _PrimaryState = value; }
        }
        public string PrimaryZip {
            get { return _PrimaryZip; }
            set { _PrimaryZip = value; }
        }
        public string PrimaryWorkersCompensation {
            get { return _PrimaryWorkersCompensation; }
            set { _PrimaryWorkersCompensation = value; }
        }
        public string PrimaryPayorCarrierCode {
            get { return _PrimaryPayorCarrierCode; }
            set { _PrimaryPayorCarrierCode = value; }
        }
        public bool ShowSecondaryInsurance {
            get { return _ShowSecondaryInsurance; }
            set { _ShowSecondaryInsurance = value; }
        }
        public string SecondaryMedicareID {
            get { return _SecondaryMedicareID; }
            set { _SecondaryMedicareID = value; }
        }
        public string SecondaryInsuranceName {
            get { return _SecondaryInsuranceName; }
            set { _SecondaryInsuranceName = value; }
        }
        public string SecondaryMemberID {
            get { return _SecondaryMemberID; }
            set { _SecondaryMemberID = value; }
        }
        public string SecondaryPlanID {
            get { return _SecondaryPlanID; }
            set { _SecondaryPlanID = value; }
        }
        public string SecondaryGroupNumber {
            get { return _SecondaryGroupNumber; }
            set { _SecondaryGroupNumber = value; }
        }
        public string SecondaryAddress {
            get { return _SecondaryAddress; }
            set { _SecondaryAddress = value; }
        }
        public string SecondaryCity {
            get { return _SecondaryCity; }
            set { _SecondaryCity = value; }
        }
        public string SecondaryState {
            get { return _SecondaryState; }
            set { _SecondaryState = value; }
        }
        public string SecondaryZip {
            get { return _SecondaryZip; }
            set { _SecondaryZip = value; }
        }
        public string SecondaryWorkersCompensation {
            get { return _SecondaryWorkersCompensation; }
            set { _SecondaryWorkersCompensation = value; }
        }
        public string SecondaryPayorCarrierCode {
            get { return _SecondaryPayorCarrierCode; }
            set { _SecondaryPayorCarrierCode = value; }
        }
        public bool ShowTertiaryInsurance {
            get { return _ShowTertiaryInsurance; }
            set { _ShowTertiaryInsurance = value; }
        }
        public string TertiaryMedicareID {
            get { return _TertiaryMedicareID; }
            set { _TertiaryMedicareID = value; }
        }
        public string TertiaryInsuranceName {
            get { return _TertiaryInsuranceName; }
            set { _TertiaryInsuranceName = value; }
        }
        public string TertiaryMemberID {
            get { return _TertiaryMemberID; }
            set { _TertiaryMemberID = value; }
        }
        public string TertiaryPlanID {
            get { return _TertiaryPlanID; }
            set { _TertiaryPlanID = value; }
        }
        public string TertiaryGroupNumber {
            get { return _TertiaryGroupNumber; }
            set { _TertiaryGroupNumber = value; }
        }
        public string TertiaryAddress {
            get { return _TertiaryAddress; }
            set { _TertiaryAddress = value; }
        }
        public string TertiaryCity {
            get { return _TertiaryCity; }
            set { _TertiaryCity = value; }
        }
        public string TertiaryState {
            get { return _TertiaryState; }
            set { _TertiaryState = value; }
        }
        public string TertiaryZip {
            get { return _TertiaryZip; }
            set { _TertiaryZip = value; }
        }
        public string TertiaryWorkersCompensation {
            get { return _TertiaryWorkersCompensation; }
            set { _TertiaryWorkersCompensation = value; }
        }
        public string TertiaryPayorCarrierCode {
            get { return _TertiaryPayorCarrierCode; }
            set { _TertiaryPayorCarrierCode = value; }
        }
        public bool ShowAFP {
            get { return _ShowAFP; }
            set { _ShowAFP = value; }
        }
        public string AFP_GestationalAge {
            get { return _AFP_GestationalAge; }
            set { _AFP_GestationalAge = value; }
        }
        public string AFP_GestationalAgeDate {
            get { return _AFP_GestationalAgeDate; }
            set { _AFP_GestationalAgeDate = value; }
        }
        public string AFP_ByLMP {
            get { return _AFP_ByLMP; }
            set { _AFP_ByLMP = value; }
        }
        public string AFP_ByLMPDate {
            get { return _AFP_ByLMPDate; }
            set { _AFP_ByLMPDate = value; }
        }
        public string AFP_ByUS {
            get { return _AFP_ByUS; }
            set { _AFP_ByUS = value; }
        }
        public string AFP_ByUSDate {
            get { return _AFP_ByUSDate; }
            set { _AFP_ByUSDate = value; }
        }
        public string AFP_ByEDD {
            get { return _AFP_ByEDD; }
            set { _AFP_ByEDD = value; }
        }
        public string AFP_ByEddDate {
            get { return _AFP_ByEddDate; }
            set { _AFP_ByEddDate = value; }
        }
        public string AFP_PatientWeight {
            get { return _AFP_PatientWeight; }
            set { _AFP_PatientWeight = value; }
        }
        public string AFP_TypeOfPregnancy {
            get { return _AFP_TypeOfPregnancy; }
            set { _AFP_TypeOfPregnancy = value; }
        }
        public string AFP_InsulinDependent {
            get { return _AFP_InsulinDependent; }
            set { _AFP_InsulinDependent = value; }
        }
        public string AFP_PatientRace {
            get { return _AFP_PatientRace; }
            set { _AFP_PatientRace = value; }
        }
        public string AFP_RoutineScreening {
            get { return _AFP_RoutineScreening; }
            set { _AFP_RoutineScreening = value; }
        }
        public string AFP_PreviousNeuralTubeDefect {
            get { return _AFP_PreviousNeuralTubeDefect; }
            set { _AFP_PreviousNeuralTubeDefect = value; }
        }
        public string AFP_AdvancedMaternalAge {
            get { return _AFP_AdvancedMaternalAge; }
            set { _AFP_AdvancedMaternalAge = value; }
        }
        public string AFP_HistoryOfDownSyndrome {
            get { return _AFP_HistoryOfDownSyndrome; }
            set { _AFP_HistoryOfDownSyndrome = value; }
        }
        public string AFP_HistoryOfCysticFibrosis {
            get { return _AFP_HistoryOfCysticFibrosis; }
            set { _AFP_HistoryOfCysticFibrosis = value; }
        }
        public string AFP_OtherIndications {
            get { return _AFP_OtherIndications; }
            set { _AFP_OtherIndications = value; }
        }
        public string AFP_Comment {
            get { return _AFP_Comment; }
            set { _AFP_Comment = value; }
        }
        public string AFP_Elevated {
            get { return _AFP_Elevated; }
            set { _AFP_Elevated = value; }
        }
        public string AFP_EarlyGA {
            get { return _AFP_EarlyGA; }
            set { _AFP_EarlyGA = value; }
        }
        public string AFP_Hemolyzed {
            get { return _AFP_Hemolyzed; }
            set { _AFP_Hemolyzed = value; }
        }
        public bool ShowCytology {
            get { return _ShowCytology; }
            set { _ShowCytology = value; }
        }
        public string Cytology_GynSource {
            get { return _Cytology_GynSource; }
            set { _Cytology_GynSource = value; }
        }
        public string Cytology_DateLMP_Menopause {
            get { return _Cytology_DateLMP_Menopause; }
            set { _Cytology_DateLMP_Menopause = value; }
        }
        public string Cytology_CollectionTechnique {
            get { return _Cytology_CollectionTechnique; }
            set { _Cytology_CollectionTechnique = value; }
        }
        public string Cytology_PreviousTreatment {
            get { return _Cytology_PreviousTreatment; }
            set { _Cytology_PreviousTreatment = value; }
        }
        public string Cytology_PreviousCytology {
            get { return _Cytology_PreviousCytology; }
            set { _Cytology_PreviousCytology = value; }
        }
        public string Cytology_OtherPatientInformation {
            get { return _Cytology_OtherPatientInformation; }
            set { _Cytology_OtherPatientInformation = value; }
        }
        public bool ShowBloodLead {
            get { return _ShowBloodLead; }
            set { _ShowBloodLead = value; }
        }
        public string BloodLeadRace {
            get { return _BloodLeadRace; }
            set { _BloodLeadRace = value; }
        }
        public string BloodLeadType {
            get { return _BloodLeadType; }
            set { _BloodLeadType = value; }
        }
        public string BloodLeadHispanic {
            get { return _BloodLeadHispanic; }
            set { _BloodLeadHispanic = value; }
        }
        public string BloodLeadPurpose {
            get { return _BloodLeadPurpose; }
            set { _BloodLeadPurpose = value; }
        }
        #endregion
    }
    public class ResultMessage {
        private string _MessageDateTime = string.Empty;
        string _PatientID = string.Empty;
        string _PatientLastName = string.Empty;
        string _PatientFirstName = string.Empty;
        string _PatientDateOfBirth = string.Empty;
        string _PatientSex = string.Empty;
        string _PatientAddress = string.Empty;
        string _PatientCity = string.Empty;
        string _PatientState = string.Empty;
        string _PatientZip = string.Empty;
        string _PatientHomePhoneNumber = string.Empty;
        string _Fasting = string.Empty;
        string _ReportStatus = string.Empty;
        string _ReportComment = string.Empty;
        List<Order> _Orders = new List<Order>();
        List<Lab> _Labs = new List<Lab>();
        public string MessageDateTime {
            get { return _MessageDateTime; }
            set { _MessageDateTime = value; }
        }
        public string PatientID {
            get { return _PatientID; }
            set { _PatientID = value; }
        }
        public string PatientLastName {
            get { return _PatientLastName; }
            set { _PatientLastName = value; }
        }
        public string PatientFirstName {
            get { return _PatientFirstName; }
            set { _PatientFirstName = value; }
        }
        public string PatientDateOfBirth {
            get { return _PatientDateOfBirth; }
            set { _PatientDateOfBirth = value; }
        }
        public string PatientSex {
            get { return _PatientSex; }
            set { _PatientSex = value; }
        }
        public string PatientAddress {
            get { return _PatientAddress; }
            set { _PatientAddress = value; }
        }
        public string PatientCity {
            get { return _PatientCity; }
            set { _PatientCity = value; }
        }
        public string PatientState {
            get { return _PatientState; }
            set { _PatientState = value; }
        }
        public string PatientZip {
            get { return _PatientZip; }
            set { _PatientZip = value; }
        }
        public string PatientHomePhoneNumber {
            get { return _PatientHomePhoneNumber; }
            set { _PatientHomePhoneNumber = value; }
        }
        public string Fasting {
            get { return _Fasting; }
            set { _Fasting = value; }
        }
        public string ReportStatus {
            get { return _ReportStatus; }
            set { _ReportStatus = value; }
        }
        public string ReportComment {
            get { return _ReportComment; }
            set { _ReportComment = value; }
        }
        public List<Order> Orders {
            get { return _Orders; }
            set { _Orders = value; }
        }
        public List<Lab> Labs {
            get { return _Labs; }
            set { _Labs = value; }
        }
        public ResultMessage(HL7.HL7Message message) {
            List<HL7.MessageHeaderSegment> headers = new List<HL7.MessageHeaderSegment>(message.RetrieveSegmentSequence<HL7.MessageHeaderSegment>().Values);
            if (headers.Count != 1) { throw new Exception("Can only have one MSH segment!"); }
            HL7.MessageHeaderSegment msh = new List<HL7.MessageHeaderSegment>(headers)[0];

            if (msh.TypedDateTimeOfMessage.HasValue) {
                _MessageDateTime = msh.TypedDateTimeOfMessage.Value.ToString("MM/dd/yyyy hh:mm tt");
            } else {
                _MessageDateTime = string.Empty;
            }
            SortedDictionary<int, HL7.PatientIdentificationSegment> patients = new SortedDictionary<int, HL7.PatientIdentificationSegment>(message.RetrieveSegmentSequence<HL7.PatientIdentificationSegment>());
            if (patients.Count != 1) { throw new Exception("Can only have one PID segment!"); }
            HL7.PatientIdentificationSegment pid = new List<HL7.PatientIdentificationSegment>(patients.Values)[0];
            _PatientID = pid.ExternalPatientID.Value.Trim();
            if (string.IsNullOrEmpty(_PatientID)) {
                _PatientID = "Not returned by the lab";
            }
            _PatientLastName = pid.PatientLastName.Value.Trim();
            _PatientFirstName = pid.PatientFirstName.Value.Trim();
            try {
                _PatientDateOfBirth = DateTime.ParseExact(pid.PatientDateOfBirth.Value.Trim(), "yyyyMMdd", System.Globalization.DateTimeFormatInfo.CurrentInfo).ToString("MM/dd/yyyy");
            } catch {
                _PatientDateOfBirth = string.Empty;
                System.Diagnostics.Debug.WriteLine("ResultMessage - Parsing the Patient's DOB failed: " + pid.PatientDateOfBirth);
            }
            _PatientSex = pid.PatientSex.Value.Trim();
            _PatientAddress = pid.PatientAddress.Value.Trim();
            _PatientCity = pid.PatientCity.Value.Trim();
            _PatientState = pid.PatientStateOrProvice.Value.Trim();
            _PatientZip = Formatter.FormatZipCode(pid.PatientZipOrPostalCode.Value.Trim());
            _PatientHomePhoneNumber = Formatter.FormatPhoneNumber(pid.PatientHomePhoneNumber.Value.Trim());
            _Fasting = pid.Fasting.Value.Trim().Length == 0 ? "UNK" : pid.Fasting.Value.Trim();
            string status = pid.StatusOfSpecimen.Value.Trim().ToUpper();
            //Quest puts it somewhere else...
            if (string.IsNullOrEmpty(status)) {
                if (message.RetrieveSegmentSequence<HL7.CommonOrderSegment>().Count == 1) {
                    int key = new List<int>(message.RetrieveSegmentSequence<HL7.CommonOrderSegment>().Keys)[0];
                    status = message.RetrieveSegmentSequence<HL7.CommonOrderSegment>()[key].OrderStatus.Value.Trim().ToUpper();
                    if (status == "CM") {
                        _ReportStatus = "Order Complete";
                    } else if (status == "IP") {
                        _ReportStatus = "Preliminary";
                    }
                }
            } else {
                if (status == "F") {
                    _ReportStatus = "Final";
                } else if (status == "P") {
                    _ReportStatus = "Preliminary";
                }
            }
            SortedDictionary<int, HL7.PlaceOfServiceFacilitySegment> labs = message.RetrieveSegmentSequence<HL7.PlaceOfServiceFacilitySegment>();
            foreach (HL7.PlaceOfServiceFacilitySegment zps in labs.Values) {
                Labs.Add(new Lab(zps));
            }
            SortedDictionary<int, HL7.NotesAndCommentsSegment> notes = message.RetrieveSegmentSequence<HL7.NotesAndCommentsSegment>();
            SortedDictionary<int, HL7.AddendumSegment> addendums = message.RetrieveSegmentSequence<HL7.AddendumSegment>();
            SortedDictionary<int, HL7.CommonOrderSegment> orders = message.RetrieveSegmentSequence<HL7.CommonOrderSegment>();
            SortedDictionary<int, HL7.ObservationOrderSegment> observationOrders = message.RetrieveSegmentSequence<HL7.ObservationOrderSegment>();
            SortedDictionary<int, HL7.ObservationResultSegment> observations = message.RetrieveSegmentSequence<HL7.ObservationResultSegment>();

            //seeing if there's report comments between pid and orcList<int> patientKeys = new List<int>(patients.Keys);
            List<int> patientKeys = new List<int>(patients.Keys);
            if (patientKeys.Count != 1) { throw new Exception("Can only have one PID segment!"); }
            int patientKey = patientKeys[0];
            int noteKey = patientKey + 1;
            while (notes.ContainsKey(noteKey)) {
                if (noteKey == (patientKey + 1)) {
                    this.ReportComment += notes[noteKey].CommentText;
                } else {
                    this.ReportComment += Environment.NewLine + notes[noteKey].CommentText;
                }
                noteKey++;
            }
            List<Order> resultOrders = new List<Order>();
            Dictionary<string, Lab> orderLabs = new Dictionary<string, Lab>();
            foreach (KeyValuePair<int, HL7.ObservationOrderSegment> observationPair in observationOrders) {
                //Yes going backwards prolly bad, but whatever.  Don't feel like changing the loop again.
                int orderKey = observationPair.Key - 1;
                if (!orders.ContainsKey(orderKey)) {
                    if (orders.Count != 1) {
                        throw new Exception("OBR Without Matching ORC!");
                    }
                    orderKey = new List<int>(orders.Keys)[0];
                }
                Order resultOrder = new Order(orders[orderKey], observationPair.Value);
                //Quest doesn't use zps
                if (Labs.Count == 0 && observationPair.Value != null && observationPair.Value.ProducerField2 != null && observationPair.Value.ProducerField2.Value != null && observationPair.Value.ProducerField2.Value.Trim() != string.Empty) {
                    //QBA^Quest Diagnostics Incorporated^1901 Sulphur Spring Road^Baltimore^MD^21227^Robert R. L. Smith, M.D.
                    string[] labLines = observationPair.Value.ProducerField2.Value.Split(new string[] { "~" }, StringSplitOptions.RemoveEmptyEntries);
                    foreach (string line in labLines) {
                        string[] split = line.Split(new string[] { "^" }, StringSplitOptions.RemoveEmptyEntries);
                        if (split != null && split.Length > 0) {
                            string id = string.Empty;
                            string name = string.Empty;
                            string address = string.Empty;
                            string city = string.Empty;
                            string state = string.Empty;
                            string zip = string.Empty;
                            string phone = string.Empty;
                            string director = string.Empty;
                            if (split.Length > 0) { id = split[0].Trim(); }
                            if (split.Length > 1) { name = split[1].Trim(); }
                            if (split.Length > 2) { address = split[2].Trim(); }
                            if (split.Length > 3) { city = split[3].Trim(); }
                            if (split.Length > 4) { state = split[4].Trim(); }
                            if (split.Length > 5) { zip = split[5].Trim(); }
                            //if (split.Length > 6) { phone = split[6].Trim(); }
                            if (split.Length > 6) { director = split[6].Trim(); }
                            if (!orderLabs.ContainsKey(id)) {
                                Lab l = new Lab(id, name, address, city, state, zip, phone, director);
                                orderLabs.Add(id, l);
                            }
                        }
                    }
                }
                //OBX next, unless the ever-possible addendum is there...
                int obxPosition = observationPair.Key + 1;
                while (addendums.ContainsKey(obxPosition)) { obxPosition++; }
                //if there's notes in the way (Hermon Memorial, FU)
                List<HL7.NotesAndCommentsSegment> prependedNotes = new List<HL7.NotesAndCommentsSegment>();
                while (notes.ContainsKey(obxPosition)) {
                    resultOrder.AddNotes(notes[obxPosition]);
                    obxPosition++;
                }
                if (!observations.ContainsKey(obxPosition)) { throw new Exception("OBR Without Matching Observations(OBX)!"); }
                while (observations.ContainsKey(obxPosition)) {
                    Observation obx = new Observation(observations[obxPosition]);
                    //notes
                    int ntePosition = obxPosition + 1;
                    while (addendums.ContainsKey(ntePosition)) { ntePosition++; }
                    while (notes.ContainsKey(ntePosition)) {
                        HL7.NotesAndCommentsSegment nte = notes[ntePosition];
                        ntePosition++;
                        //Still could be addendums inbetween...
                        while (addendums.ContainsKey(ntePosition)) {
                            //This is the only place we'd really need to worry about an addendum.  append the ADD text to the note's text
                            nte.CommentText.Value += Environment.NewLine + addendums[ntePosition].ContinuationOfPreviousLogicalRecord.Value ?? string.Empty;
                            ntePosition++;
                        }
                        obx.AddNotes(nte);
                    }
                    resultOrder.Observations.Add(obx);
                    //The next obx should be after the last nte
                    obxPosition = ntePosition;
                    //Still could be addendums inbetween...
                    while (addendums.ContainsKey(obxPosition)) { obxPosition++; }
                }
                Orders.Add(resultOrder);
            }
            if (Labs.Count == 0 && orderLabs.Count > 0) { Labs.AddRange(orderLabs.Values); }
        }
    }
    public class Order {
        string _SpecimenID = string.Empty;
        string _OrderCode = string.Empty;
        string _OrderDescription = string.Empty;
        string _OrderingPhysician = string.Empty;
        string _Status = string.Empty;
        string _SpecimenCollectionDateTime = string.Empty;
        string _SpecimenReceivedDateTime = string.Empty;
        string _SpecimenReportedDateTime = string.Empty;
        List<Observation> _Observations = new List<Observation>();
        StringBuilder _Notes = new StringBuilder();
        public Order(HL7.CommonOrderSegment orc, HL7.ObservationOrderSegment obr) {
            _SpecimenID = obr.UniqueForeignSpecimenID.Value.Trim();
            _OrderCode = obr.ObservationBatteryID.Value.Trim();
            _OrderDescription = obr.ObservationBatteryText.Value.Trim();
            _OrderingPhysician = orc.OrderingProviderLastName.Value.Trim() + ", " + orc.OrderingProviderFirstInitial.Value.Trim();
            string status = obr.OrderResultStatus.Value.Trim().ToUpper();
            if (status == "F") {
                _Status = "Final";
            } else if (status == "P") {
                _Status = "Preliminary";
            } else if (status == "X") {
                _Status = "Cancelled";
            } else if (status == "C") {
                _Status = "Corrected";
            }
            if (obr.TypedObservationCollectionDateTime.HasValue) {
                _SpecimenCollectionDateTime = obr.TypedObservationCollectionDateTime.Value.ToString("MM/dd/yyyy hh:mm tt");
            } else {
                _SpecimenCollectionDateTime = string.Empty;
            }
            if (obr.TypedSpecimenReceivedDateTime.HasValue) {
                _SpecimenReceivedDateTime = obr.TypedSpecimenReceivedDateTime.Value.ToString("MM/dd/yyyy hh:mm tt");
            } else {
                SpecimenReceivedDateTime = string.Empty;
            }
            if (obr.TypedDateTimeObservationReported.HasValue) {
                _SpecimenReportedDateTime = obr.TypedDateTimeObservationReported.Value.ToString("MM/dd/yyyy hh:mm tt");
            } else {
                _SpecimenReportedDateTime = string.Empty;
            }
        }
        public string SpecimenID {
            get { return _SpecimenID; }
            set { _SpecimenID = value; }
        }
        public string OrderCode {
            get { return _OrderCode; }
            set { _OrderCode = value; }
        }
        public string OrderDescription {
            get { return _OrderDescription; }
            set { _OrderDescription = value; }
        }
        public string OrderingPhysician {
            get { return _OrderingPhysician; }
            set { _OrderingPhysician = value; }
        }
        public string Status {
            get { return _Status; }
            set { _Status = value; }
        }
        public string SpecimenCollectionDateTime {
            get { return _SpecimenCollectionDateTime; }
            set { _SpecimenCollectionDateTime = value; }
        }
        public string SpecimenReceivedDateTime {
            get { return _SpecimenReceivedDateTime; }
            set { _SpecimenReceivedDateTime = value; }
        }
        public string SpecimenReportedDateTime {
            get { return _SpecimenReportedDateTime; }
            set { _SpecimenReportedDateTime = value; }
        }
        public List<Observation> Observations {
            get { return _Observations; }
            set { _Observations = value; }
        }
        public string Notes {
            get { return _Notes.ToString(); }
        }
        public void AddNotes(HL7.NotesAndCommentsSegment nte) {
            if (nte.CommentText.Value.Trim() != ".") {
                _Notes.AppendLine(nte.CommentText.Value);
            } else {
                _Notes.AppendLine(string.Empty);
            }
        }
    }
    public class Observation {
        string _Text = string.Empty;
        string _Value = string.Empty;
        string _Range = string.Empty;
        string _ValueFlag = string.Empty;
        string _Status = string.Empty;
        string _LabID = string.Empty;
        StringBuilder _Notes = new StringBuilder();
        public Observation(HL7.ObservationResultSegment obx) {
            _Text = obx.ObservationText.Value.Trim();
            _Value = obx.ObservationValue.Value.Trim() + obx.UnitOfMeasureIdentifier.Value.Trim();
            _Range = obx.ReferenceRanges.Value.Trim();
            if (obx.ProducerID.Value.Contains("^")) {
                string[] labs = obx.ProducerID.Value.Split(new char[] { '^' }, StringSplitOptions.RemoveEmptyEntries);
                if (labs.Length > 0) {
                    _LabID = labs[0].Trim();
                } else {
                    _LabID = string.Empty;
                }
            } else {
                _LabID = obx.ProducerID.Value.Trim();
            }
            string flag = obx.AbnormalFlags.Value.Trim().ToUpper();
            switch (flag) {
                case "L":
                    _ValueFlag = "Below Normal";
                    break;
                case "H":
                    _ValueFlag = "Above Normal";
                    break;
                case "LL":
                    _ValueFlag = "Critical - Low";
                    break;
                case "HH":
                    _ValueFlag = "Critical - High";
                    break;
                case "A":
                    _ValueFlag = "Abnormal";
                    break;
                case ">":
                    _ValueFlag = "Panic - High";
                    break;
                case "<":
                    _ValueFlag = "Panic - Low";
                    break;
                default:
                    _ValueFlag = string.Empty;
                    break;
            }
            string status = obx.ObservationResultStatus.Value.Trim().ToUpper();
            switch (status) {
                case "P":
                    _Status = "Preliminary";
                    break;
                case "X":
                    _Status = "TNP";
                    break;
                case "N":
                    _Status = "DNR";
                    break;
                case "F":
                    _Status = "Final";
                    break;
                case "S":
                    _Status = "Partial";
                    break;
                case "C":
                    _Status = "Corrected";
                    break;
                default:
                    _Status = string.Empty;
                    break;
            }
        }
        public string Text {
            get { return _Text; }
            set { _Text = value; }
        }
        public string Value {
            get { return _Value; }
            set { _Value = value; }
        }
        public string Range {
            get { return _Range; }
            set { _Range = value; }
        }
        public string ValueFlag {
            get { return _ValueFlag; }
            set { _ValueFlag = value; }
        }
        public string Status {
            get { return _Status; }
            set { _Status = value; }
        }
        public string LabID {
            get { return _LabID; }
            set { _LabID = value; }
        }
        public string Notes {
            get { return _Notes.ToString(); }
        }
        public void AddNotes(HL7.NotesAndCommentsSegment nte) {
            if (nte.CommentText.Value.Trim() != ".") {
                _Notes.AppendLine(nte.CommentText.Value);
            } else {
                _Notes.AppendLine(string.Empty);
            }
        }
    }
    public class Lab {
        string _LabID = string.Empty;
        string _Name = string.Empty;
        string _Address = string.Empty;
        string _City = string.Empty;
        string _State = string.Empty;
        string _Zip = string.Empty;
        string _Phone = string.Empty;
        string _Director = string.Empty;
        public Lab(string id, string name, string address, string city, string state, string zip, string phone, string director) {
            _LabID = id;
            _Name = name;
            _Address = address;
            _City = city;
            _State = state;
            _Zip = zip;
            _Phone = phone;
            _Director = director;
        }
        public Lab(HL7.PlaceOfServiceFacilitySegment zps) {
            _LabID = zps.FacilityMnemonic.Value.Trim();
            _Name = zps.FacilityName.Value.Trim();
            _Address = zps.FacilityAddress.Value.Trim();
            _City = zps.FacilityCity.Value.Trim();
            _State = zps.FacilityStateOrProvince.Value.Trim();
            _Zip = Formatter.FormatZipCode(zps.FacilityZipOrPostalCode.Value.Trim());
            _Phone = Formatter.FormatPhoneNumber(zps.FacilityPhoneNumber.Value.Trim());
            _Director = (zps.FacilityDirectorFirstName + " " + zps.FacilityDirectorLastName).Trim();
        }
        public string LabID {
            get { return _LabID; }
            set { _LabID = value; }
        }
        public string Name {
            get { return _Name; }
            set { _Name = value; }
        }
        public string Address {
            get { return _Address; }
            set { _Address = value; }
        }
        public string City {
            get { return _City; }
            set { _City = value; }
        }
        public string State {
            get { return _State; }
            set { _State = value; }
        }
        public string Zip {
            get { return _Zip; }
            set { _Zip = value; }
        }
        public string Phone {
            get { return _Phone; }
            set { _Phone = value; }
        }
        public string Director {
            get { return _Director; }
            set { _Director = value; }
        }

    }
    public sealed class Formatter {
        public static string FormatPhoneNumber(string p) {
            if (p == null) { return string.Empty; }
            if (p.Trim().Length == 0) { return p.Trim(); }
            StringBuilder phoneBuilder = new StringBuilder();
            //So we can format however we want
            foreach (char c in p.ToCharArray()) {
                if (char.IsNumber(c)) { phoneBuilder.Append(c); }
            }
            p = phoneBuilder.ToString().Trim();
            if (p.Length < 10) { return p.Trim(); }
            string last4 = p.Substring(p.Length - 4, 4);
            string middle3 = p.Substring(p.Length - 7, 3);
            string area = p.Substring(p.Length - 10, 3);
            string intCode = p.Substring(0, p.Length - 10);
            if (intCode.Length > 0) { intCode += "-"; }
            return intCode + area + "-" + middle3 + "-" + last4;
        }
        public static string FormatZipCode(string z) {
            StringBuilder zipBuilder = new StringBuilder();
            //So we can format however we want
            foreach (char c in z.ToCharArray()) {
                if (char.IsNumber(c)) { zipBuilder.Append(c); }
            }
            z = zipBuilder.ToString();
            if (z.Length == 9) {
                z = z.Substring(0, 5) + "-" + z.Substring(5, 4);
            }
            return z;
        }
        public static string FormatSocialSecurityNumber(string ssn) {
            StringBuilder ssnBuilder = new StringBuilder();
            //So we can format however we want
            foreach (char c in ssn.ToCharArray()) {
                if (char.IsNumber(c)) { ssnBuilder.Append(c); }
            }
            ssn = ssnBuilder.ToString();
            if (ssn.Length == 9) {
                ssn = ssn.Substring(0, 3) + "-" + ssn.Substring(3, 2) + "-" + ssn.Substring(5, 4);
            }
            return ssn;
        }
    }
}
