using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class GuarantorSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _GuarantorNumber = new Field();
        private Field _GuarantorLastName = new Field();
        private Field _GuarantorFirstName = new Field();
        private Field _GuarantorSpouseName = new Field();
        private Field _GuarantorAddress = new Field();
        private Field _GuarantorOtherDesignation = new Field();
        private Field _GuarantorCity = new Field();
        private Field _GuarantorState = new Field();
        private Field _GuarantorZipCode = new Field();
        private Field _GuarantorHomePhoneNumber = new Field();
        private Field _GuarantorWorkPhoneNumber = new Field();
        private Field _GuarantorDOB = new Field();
        private Field _GuarantorSex = new Field();
        private Field _GuarantorType = new Field();
        private Field _GuarantorRelationshipToPatient = new Field();
        private Field _GuarantorSocialSecurityNumber = new Field();
        private Field _GuarantorDateTimeBegin = new Field();
        private Field _GuarantorDateTimeEnd = new Field();
        private Field _GuarantorPriority = new Field();
        private Field _GuarantorsEmployerName = new Field();
        private Field _GuarantorsEmployerAddress = new Field();
        private Field _GuarantorsEmployerPhoneNumber = new Field();
        private Field _GuarantorsEmployerIDNumber = new Field();
        private Field _GuarantorsEmploymentStatus = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field GuarantorNumber {
            get {
                return _GuarantorNumber;
            }
            private set {
                _GuarantorNumber = value;
            }
        }
        public Field GuarantorLastName {
            get {
                return _GuarantorLastName;
            }
            private set {
                _GuarantorLastName = value;
            }
        }
        public Field GuarantorFirstName {
            get {
                return _GuarantorFirstName;
            }
            private set {
                _GuarantorFirstName = value;
            }
        }
        public Field GuarantorSpouseName {
            get {
                return _GuarantorSpouseName;
            }
            private set {
                _GuarantorSpouseName = value;
            }
        }
        public Field GuarantorAddress {
            get {
                return _GuarantorAddress;
            }
            private set {
                _GuarantorAddress = value;
            }
        }
        public Field GuarantorOtherDesignation {
            get {
                return _GuarantorOtherDesignation;
            }
            private set {
                _GuarantorOtherDesignation = value;
            }
        }
        public Field GuarantorCity {
            get {
                return _GuarantorCity;
            }
            private set {
                _GuarantorCity = value;
            }
        }
        public Field GuarantorState {
            get {
                return _GuarantorState;
            }
            private set {
                _GuarantorState = value;
            }
        }
        public Field GuarantorZipCode {
            get {
                return _GuarantorZipCode;
            }
            private set {
                _GuarantorZipCode = value;
            }
        }
        public Field GuarantorHomePhoneNumber {
            get {
                return _GuarantorHomePhoneNumber;
            }
            private set {
                _GuarantorHomePhoneNumber = value;
            }
        }
        public Field GuarantorWorkPhoneNumber {
            get {
                return _GuarantorWorkPhoneNumber;
            }
            private set {
                _GuarantorWorkPhoneNumber = value;
            }
        }
        public Field GuarantorDOB {
            get {
                return _GuarantorDOB;
            }
            private set {
                _GuarantorDOB = value;
            }
        }
        public Field GuarantorSex {
            get {
                return _GuarantorSex;
            }
            private set {
                _GuarantorSex = value;
            }
        }
        public Field GuarantorType {
            get {
                return _GuarantorType;
            }
            private set {
                _GuarantorType = value;
            }
        }
        public Field GuarantorRelationshipToPatient {
            get {
                return _GuarantorRelationshipToPatient;
            }
            private set {
                _GuarantorRelationshipToPatient = value;
            }
        }
        public Field GuarantorSocialSecurityNumber {
            get {
                return _GuarantorSocialSecurityNumber;
            }
            private set {
                _GuarantorSocialSecurityNumber = value;
            }
        }
        public Field GuarantorDateTimeBegin {
            get {
                return _GuarantorDateTimeBegin;
            }
            private set {
                _GuarantorDateTimeBegin = value;
            }
        }
        public Field GuarantorDateTimeEnd {
            get {
                return _GuarantorDateTimeEnd;
            }
            private set {
                _GuarantorDateTimeEnd = value;
            }
        }
        public Field GuarantorPriority {
            get {
                return _GuarantorPriority;
            }
            private set {
                _GuarantorPriority = value;
            }
        }
        public Field GuarantorsEmployerName {
            get {
                return _GuarantorsEmployerName;
            }
            private set {
                _GuarantorsEmployerName = value;
            }
        }
        public Field GuarantorsEmployerAddress {
            get {
                return _GuarantorsEmployerAddress;
            }
            private set {
                _GuarantorsEmployerAddress = value;
            }
        }
        public Field GuarantorsEmployerPhoneNumber {
            get {
                return _GuarantorsEmployerPhoneNumber;
            }
            private set {
                _GuarantorsEmployerPhoneNumber = value;
            }
        }
        public Field GuarantorsEmployerIDNumber {
            get {
                return _GuarantorsEmployerIDNumber;
            }
            private set {
                _GuarantorsEmployerIDNumber = value;
            }
        }
        public Field GuarantorsEmploymentStatus {
            get {
                return _GuarantorsEmploymentStatus;
            }
            private set {
                _GuarantorsEmploymentStatus = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, GuarantorNumber, GuarantorLastName, GuarantorFirstName, GuarantorSpouseName, GuarantorAddress, GuarantorOtherDesignation, GuarantorCity, GuarantorState, GuarantorZipCode, GuarantorHomePhoneNumber, GuarantorWorkPhoneNumber, GuarantorDOB, GuarantorSex, GuarantorType, GuarantorRelationshipToPatient, GuarantorSocialSecurityNumber, GuarantorDateTimeBegin, GuarantorDateTimeEnd, GuarantorPriority, GuarantorsEmployerName, GuarantorsEmployerAddress, GuarantorsEmployerPhoneNumber, GuarantorsEmployerIDNumber, GuarantorsEmploymentStatus });
            }
        }
        public override string SegmentType {
            get {
                return "GT1";
            }
        }
        public override string Title {
            get {
                return "Guarantor";
            }
        }
        #endregion
        #region Constructors
        public GuarantorSegment() {
            SegmentTypeID = new Field("Segment Type ID", "GT1.1", "Identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaNumeric, 0, "GT1");
            SequenceNumber = new Field("Sequence Number", "GT1.2", "To identify the number of GT1 segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 405, string.Empty);
            GuarantorNumber = new Field("Guarantor Number", "GT1.3", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 406, string.Empty);
            GuarantorLastName = new Field("Guarantor Last Name", "GT1.4", "Responsible party identifier", RequiredFlags.AlwaysRequired, 12, string.Empty, SupportedCharacters.AlphaOnly, 407, string.Empty);
            GuarantorFirstName = new Field("Guarantor First Name", "GT1.4", "Responsible party identifier", RequiredFlags.AlwaysRequired, 9, string.Empty, SupportedCharacters.AlphaOnly, 407, string.Empty);
            GuarantorSpouseName = new Field("Guarantor Spouse Name", "GT1.5", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 408, string.Empty);
            GuarantorAddress = new Field("Guarantor Address", "GT1.6", "Responsible party demographics", RequiredFlags.AlwaysRequired, 35, string.Empty, SupportedCharacters.AlphaNumericSpecial, 409, string.Empty);
            GuarantorOtherDesignation = new Field("Guarantor Other Designation", "GT1.6", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 409, string.Empty);
            GuarantorCity = new Field("Guarantor City", "GT1.6", "Responsible party demographics", RequiredFlags.AlwaysRequired, 16, string.Empty, SupportedCharacters.AlphaOnly, 409, string.Empty);
            GuarantorState = new Field("Guarantor State", "GT1.6", "Responsible party demographics", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaOnly, 409, string.Empty);
            GuarantorZipCode = new Field("Guarantor Zip Code", "GT1.6", "Responsible party demographics", RequiredFlags.AlwaysRequired, 9, string.Empty, SupportedCharacters.NumericOnly, 409, string.Empty);
            GuarantorHomePhoneNumber = new Field("Guarantor Home Phone Number", "GT1.7", "This phone number can be the Guarantor's or the Patient's phone number", RequiredFlags.AlwaysRequired, 10, string.Empty, SupportedCharacters.NumericOnly, 410, string.Empty);
            GuarantorWorkPhoneNumber = new Field("Guarantor Work Phone Number", "GT1.8", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 411, string.Empty);
            GuarantorDOB = new Field("Guarantor DOB", "GT1.9", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 412, string.Empty);
            GuarantorSex = new Field("Guarantor Sex", "GT1.10", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 413, string.Empty);
            GuarantorType = new Field("Guarantor Type", "GT1.11", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 414, string.Empty);
            GuarantorRelationshipToPatient = new Field("Guarantor Relationship to Patient", "GT1.12", "To identify the relationship of the patient to the subscriber", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.NumericOnly, 415, string.Empty);
            GuarantorSocialSecurityNumber = new Field("Guarantor Social Security Number", "GT1.13", "Used in outbound file only", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 416, string.Empty);
            GuarantorDateTimeBegin = new Field("Guarantor Date/Time Begin", "GT1.14", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 417, string.Empty);
            GuarantorDateTimeEnd = new Field("Guarantor Date/Time End", "GT1.15", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 418, string.Empty);
            GuarantorPriority = new Field("Guarantor Priority", "GT1.16", "Not currently saved, used, or returned", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 419, string.Empty);
            GuarantorsEmployerName = new Field("Guarantor's Employer Name", "GT1.17", "For demographic purposes and required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 420, string.Empty);
            GuarantorsEmployerAddress = new Field("Guarantor's Employer Address", "GT1.18", "For demographic purposes and required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 420, string.Empty);
            GuarantorsEmployerPhoneNumber = new Field("Guarantor's Employer Ph", "GT1.19", "For demographic purposes and required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 420, string.Empty);
            GuarantorsEmployerIDNumber = new Field("Guarantor's Employer ID", "GT1.20", "For demographic purposes and required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 420, string.Empty);
            GuarantorsEmploymentStatus = new Field("Guarantor's Employment Status", "GT1.21", "For demographic purposes and required for certain billing options", RequiredFlags.Conditional, 15, string.Empty, SupportedCharacters.AlphaNumericSpecial, 420, string.Empty);
        }
        public GuarantorSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            SegmentTypeID.Value = fields.Count > 0 ? fields[0] : String.Empty;
            SequenceNumber.Value = fields.Count > 1 ? fields[1] : String.Empty;
            GuarantorNumber.Value = fields.Count > 2 ? fields[2] : String.Empty;
            if (fields[3].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'GT1.4'");
            }
            List<string> components = new List<string>(fields[3].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count != 2) {
                throw new ArgumentException("Unexpected number of components returned for the field 'GT1.4'.  Expected 2, returned " + components.Count);
            }
            GuarantorLastName.Value = components.Count > 0 ? components[0] : String.Empty;
            GuarantorFirstName.Value = components.Count > 1 ? components[1] : String.Empty;
            //Back to non-nested
            GuarantorSpouseName.Value = fields.Count > 4 ? fields[4] : String.Empty;
            //More nested
            if (fields[5].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'GT1.6'");
            }
            components = new List<string>(fields[5].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            if (components.Count != 5) {
                throw new ArgumentException("Unexpected number of components returned for the field 'GT1.6'.  Expected 5, returned " + components.Count);
            }
            GuarantorAddress.Value = components.Count > 0 ? components[0] : String.Empty;
            GuarantorOtherDesignation.Value = components.Count > 1 ? components[1] : String.Empty;
            GuarantorCity.Value = components.Count > 2 ? components[2] : String.Empty;
            GuarantorState.Value = components.Count > 3 ? components[3] : String.Empty;
            GuarantorZipCode.Value = components.Count > 4 ? components[4] : String.Empty;
            //Back to non-nested
            GuarantorHomePhoneNumber.Value = fields.Count > 6 ? fields[6] : String.Empty;
            GuarantorWorkPhoneNumber.Value = fields.Count > 7 ? fields[7] : String.Empty;
            GuarantorDOB.Value = fields.Count > 8 ? fields[8] : String.Empty;
            GuarantorSex.Value = fields.Count > 9 ? fields[9] : String.Empty;
            GuarantorType.Value = fields.Count > 10 ? fields[10] : String.Empty;
            GuarantorRelationshipToPatient.Value = fields.Count > 11 ? fields[11] : String.Empty;
            GuarantorSocialSecurityNumber.Value = fields.Count > 12 ? fields[12] : String.Empty;
            GuarantorDateTimeBegin.Value = fields.Count > 13 ? fields[13] : String.Empty;
            GuarantorDateTimeEnd.Value = fields.Count > 14 ? fields[14] : String.Empty;
            GuarantorPriority.Value = fields.Count > 15 ? fields[15] : String.Empty;
            GuarantorsEmployerName.Value = fields.Count > 16 ? fields[16] : String.Empty;
            GuarantorsEmployerAddress.Value = fields.Count > 17 ? fields[17] : String.Empty;
            GuarantorsEmployerPhoneNumber.Value = fields.Count > 18 ? fields[18] : String.Empty;
            GuarantorsEmployerIDNumber.Value = fields.Count > 19 ? fields[19] : String.Empty;
            GuarantorsEmploymentStatus.Value = fields.Count > 20 ? fields[20] : String.Empty;
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 21) {
                for (int x = 21; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "GT1." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public GuarantorSegment(uint sequenceNumber, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public GuarantorSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Non-nested field delimiters
            foreach (Field patientVisit in KnownFields) {
                patientVisit.Delimiter = fieldDelimiter;
            }
            //Nested field delimiters
            foreach (Field patientVisit in new Field[] { GuarantorLastName, GuarantorAddress, GuarantorOtherDesignation, GuarantorCity, GuarantorState }) {
                patientVisit.Delimiter = componentDelimiter;
            }
            //last delimiter is always a newline
            this.GuarantorsEmploymentStatus.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
