using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class DiagnosisSegment : Segment {
        #region Private Instance Variables
        private Field _SequenceNumber = new Field();
        private Field _DiagnosisCodingMethod = new Field();
        private Field _DiagnosisCode = new Field();
        #endregion
        #region Public Instance Properties
        public Field SequenceNumber {
            get {
                return _SequenceNumber;
            }
            private set {
                _SequenceNumber = value;
            }
        }
        public Field DiagnosisCodingMethod {
            get {
                return _DiagnosisCodingMethod;
            }
            private set {
                _DiagnosisCodingMethod = value;
            }
        }
        public Field DiagnosisCode {
            get {
                return _DiagnosisCode;
            }
            private set {
                _DiagnosisCode = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, SequenceNumber, DiagnosisCodingMethod, DiagnosisCode });
            }
        }
        public override string SegmentType {
            get {
                return "DG1";
            }
        }
        public override string Title {
            get {
                return "Diagnosis";
            }
        }
        #endregion
        #region Constructors
        //Assumes ICD-9 in coding method
        public DiagnosisSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "DG1.0", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaNumeric, 0, "DG1");
            this.SequenceNumber = new Field("Sequence Number", "DG1.1", "To identify the numbet of DG1 segments contained within the order file", RequiredFlags.AlwaysRequired, 4, string.Empty, SupportedCharacters.NumericOnly, 375, string.Empty);
            this.DiagnosisCodingMethod = new Field("Diagnosis Coding Method", "DG1.2", "To indicate a coding method", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaNumeric, 376, "I9");
            this.DiagnosisCode = new Field("Diagnosis Code", "DG1.3", "Physician's indication of patient's diagnosis which is used by some payors to validate the need for ordering laboratory procedures", RequiredFlags.Optional, 8, string.Empty, SupportedCharacters.AlphaNumericSpecial, 377, string.Empty);
        }
        public DiagnosisSegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 4) {
                throw new ArgumentException("Not enough fields to construct a valid diagnosis segment (DG1).  Expected at least 4, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.SequenceNumber.Value = fields[1];
            this.DiagnosisCodingMethod.Value = fields[2];
            this.DiagnosisCode.Value = fields[3];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 4) {
                for (int x = 4; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "DG1." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public DiagnosisSegment(uint sequenceNumber, string fieldDelimiter)
            : this(fieldDelimiter) {
            this.SequenceNumber.Value = sequenceNumber.ToString();
        }
        public DiagnosisSegment(string fieldDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field diagnosis in KnownFields) {
                diagnosis.Delimiter = fieldDelimiter;
            }
            //Last one is always a newline
            this.DiagnosisCode.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
