using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class CommonOrderSegment : Segment {
        #region Private Instance Variables
        private Field _OrderControl = new Field();
        private Field _UniqueForeignAccessionOrSpecimenID = new Field();
        private Field _ApplicationInstitutionID = new Field();
        private Field _FillerAccessionID = new Field();
        private Field _PlacerGroupNumber = new Field();
        private Field _OrderStatus = new Field();
        private Field _ResponseFlag = new Field();
        private Field _QuantityTiming = new Field();
        private Field _Parent = new Field();
        private Field _DateTimeOfTransaction = new Field();
        private Field _EnteredBy = new Field();
        private Field _VerifiedBy = new Field();
        private Field _OrderingProviderIDNumber = new Field();
        private Field _OrderingProviderLastName = new Field();
        private Field _OrderingProviderFirstInitial = new Field();
        private Field _OrderingProviderMiddleInitial = new Field();
        private Field _OrderingProviderSuffix = new Field();
        private Field _OrderingProviderPrefix = new Field();
        private Field _OrderingProviderDegree = new Field();
        private Field _SourceTable = new Field();
        #endregion
        #region Public Instance Properties
        public Field OrderControl {
            get {
                return _OrderControl;
            }
            private set {
                _OrderControl = value;
            }
        }
        public Field UniqueForeignAccessionOrSpecimenID {
            get {
                return _UniqueForeignAccessionOrSpecimenID;
            }
            private set {
                _UniqueForeignAccessionOrSpecimenID = value;
            }
        }
        public Field ApplicationInstitutionID {
            get {
                return _ApplicationInstitutionID;
            }
            private set {
                _ApplicationInstitutionID = value;
            }
        }
        public Field FillerAccessionID {
            get {
                return _FillerAccessionID;
            }
            private set {
                _FillerAccessionID = value;
            }
        }
        public Field PlacerGroupNumber {
            get {
                return _PlacerGroupNumber;
            }
            private set {
                _PlacerGroupNumber = value;
            }
        }
        public Field OrderStatus {
            get {
                return _OrderStatus;
            }
            private set {
                _OrderStatus = value;
            }
        }
        public Field ResponseFlag {
            get {
                return _ResponseFlag;
            }
            private set {
                _ResponseFlag = value;
            }
        }
        public Field QuantityTiming {
            get {
                return _QuantityTiming;
            }
            private set {
                _QuantityTiming = value;
            }
        }
        public Field Parent {
            get {
                return _Parent;
            }
            private set {
                _Parent = value;
            }
        }
        public Field DateTimeOfTransaction {
            get {
                return _DateTimeOfTransaction;
            }
            private set {
                _DateTimeOfTransaction = value;
            }
        }
        public DateTime? TypedDateTimeOfTransaction {
            get {
                DateTime result;
                string format = DateTimeOfTransaction.Value.Length == 12 ? "yyyyMMddHHmm" : "yyyyMMddHHmmss";
                bool parsed = DateTime.TryParseExact(DateTimeOfTransaction.Value, format, System.Globalization.DateTimeFormatInfo.CurrentInfo, System.Globalization.DateTimeStyles.None, out result);
                if (parsed) {
                    return result;
                } else {
                    return null;
                }
            }
        }
        public Field EnteredBy {
            get {
                return _EnteredBy;
            }
            private set {
                _EnteredBy = value;
            }
        }
        public Field VerifiedBy {
            get {
                return _VerifiedBy;
            }
            private set {
                _VerifiedBy = value;
            }
        }
        public Field OrderingProviderIDNumber {
            get {
                return _OrderingProviderIDNumber;
            }
            private set {
                _OrderingProviderIDNumber = value;
            }
        }
        public Field OrderingProviderLastName {
            get {
                return _OrderingProviderLastName;
            }
            private set {
                _OrderingProviderLastName = value;
            }
        }
        public Field OrderingProviderFirstInitial {
            get {
                return _OrderingProviderFirstInitial;
            }
            private set {
                _OrderingProviderFirstInitial = value;
            }
        }
        public Field OrderingProviderMiddleInitial {
            get {
                return _OrderingProviderMiddleInitial;
            }
            private set {
                _OrderingProviderMiddleInitial = value;
            }
        }
        public Field OrderingProviderSuffix {
            get {
                return _OrderingProviderSuffix;
            }
            private set {
                _OrderingProviderSuffix = value;
            }
        }
        public Field OrderingProviderPrefix {
            get {
                return _OrderingProviderPrefix;
            }
            private set {
                _OrderingProviderPrefix = value;
            }
        }
        public Field OrderingProviderDegree {
            get {
                return _OrderingProviderDegree;
            }
            private set {
                _OrderingProviderDegree = value;
            }
        }
        public Field SourceTable {
            get {
                return _SourceTable;
            }
            private set {
                _SourceTable = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, OrderControl, UniqueForeignAccessionOrSpecimenID, ApplicationInstitutionID, FillerAccessionID, PlacerGroupNumber, OrderStatus, ResponseFlag, QuantityTiming, Parent, DateTimeOfTransaction, EnteredBy, VerifiedBy, OrderingProviderIDNumber, OrderingProviderLastName, OrderingProviderFirstInitial, OrderingProviderMiddleInitial, OrderingProviderSuffix, OrderingProviderPrefix, OrderingProviderDegree, SourceTable });
            }
        }
        public override string SegmentType {
            get {
                return "ORC";
            }
        }
        public override string Title {
            get {
                return "Common Order";
            }
        }
        #endregion
        #region Constructors
        public CommonOrderSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ORC.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "ORC");
            this.OrderControl = new Field("Order Control", "ORC.2", "To identify new orders", RequiredFlags.AlwaysRequired, 2, string.Empty, SupportedCharacters.AlphaOnly, 215, string.Empty);
            this.UniqueForeignAccessionOrSpecimenID = new Field("Unique Foreign Accession orSpecimen ID", "ORC.3", "Customer specific accessioning or specimen ID", RequiredFlags.AlwaysRequired, 25, string.Empty, SupportedCharacters.AlphaNumericSpecial, 216, string.Empty);
            this.ApplicationInstitutionID = new Field("Application Institution ID", "ORC.3", "Customer specific accessioning or specimen ID", RequiredFlags.AlwaysRequired, 6, string.Empty, SupportedCharacters.AlphaNumericSpecial, 216, string.Empty);
            this.FillerAccessionID = new Field("Filler Accession ID", "ORC.4", "Used in outbound file only", RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 217, string.Empty);
            this.PlacerGroupNumber = new Field("Placer Group Number", "ORC.5", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 218, string.Empty);
            this.OrderStatus = new Field("Order Status", "ORC.6", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 219, string.Empty);
            this.ResponseFlag = new Field("Response Flag", "ORC.7", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 220, string.Empty);
            this.QuantityTiming = new Field("Quantity Timing", "ORC.8", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 221, string.Empty);
            this.Parent = new Field("Parent", "ORC.9", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 222, string.Empty);
            this.DateTimeOfTransaction = new Field("Date/Time of Transaction", "ORC.10", "Record of the date and time the electronic order was created", RequiredFlags.AlwaysRequired, 14, string.Empty, SupportedCharacters.NumericOnly, 223, string.Empty);
            this.EnteredBy = new Field("Entered By", "ORC.11", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 224, string.Empty);
            this.VerifiedBy = new Field("Verified By", "ORC.12", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 225, string.Empty);
            this.OrderingProviderIDNumber = new Field("Ordering Provider ID Number", "ORC.13", "Physcian/provider ID and required for certain billing options", RequiredFlags.Optional, 20, string.Empty, SupportedCharacters.AlphaNumericSpecial, 226, string.Empty);
            this.OrderingProviderLastName = new Field("Ordering Provider Last Name", "ORC.13", "Physcian/provider ID and required for certain billing options", RequiredFlags.Optional, 9, string.Empty, SupportedCharacters.AlphaOnly, 226, string.Empty);
            this.OrderingProviderFirstInitial = new Field("Ordering Provider First Initial", "ORC.13", "Physcian/provider ID and required for certain billing options", RequiredFlags.Optional, 1, string.Empty, SupportedCharacters.AlphaOnly, 226, string.Empty);
            this.OrderingProviderMiddleInitial = new Field("Ordering Provider Middle Initial", "ORC.13", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 226, string.Empty);
            this.OrderingProviderSuffix = new Field("Ordering Provider Suffix", "ORC.13", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 226, string.Empty);
            this.OrderingProviderPrefix = new Field("Ordering Provider Prefix", "ORC.13", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 226, string.Empty);
            this.OrderingProviderDegree = new Field("Ordering Provider Degree", "ORC.13", string.Empty, RequiredFlags.Unused, -1, string.Empty, SupportedCharacters.Unused, 226, string.Empty);
            this.SourceTable = new Field("Source Table", "ORC.13", "Identification of ordering provider ID sent in ORC 13.1", RequiredFlags.Conditional, 1, string.Empty, SupportedCharacters.AlphaOnly, 226, string.Empty);
        }
        public CommonOrderSegment(string message, string fieldDelimiter, string componentDelimiter)
            : this(fieldDelimiter, componentDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 6) {
                throw new ArgumentException("Not enough fields to construct a valid common order segment (ORC).  Expected at least 6, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.OrderControl.Value = fields[1];
            List<string> components = new List<string>();
            if (fields[2].Contains(componentDelimiter) == false) {
                System.Diagnostics.Debug.WriteLine("Warning - Missing component delimiter in field 'ORC.3'");
                UniqueForeignAccessionOrSpecimenID.Value = fields[2].Trim();
            } else {
                components = new List<string>(fields[2].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
                //A field can have seperate components, essentially nested fields with a differnt delimiter
                if (components.Count != 2) {
                    System.Diagnostics.Debug.WriteLine("Warning - Unexpected number of components returned from field 'ORC.3'.  Expected 2, returned " + components.Count);
                }
                UniqueForeignAccessionOrSpecimenID.Value = components.Count > 0 ? components[0] : String.Empty;
                ApplicationInstitutionID.Value = components.Count > 1 ? components[1] : String.Empty;
            }
            //Back to non-nested fields
            FillerAccessionID.Value = fields[3];
            PlacerGroupNumber.Value = fields[4];
            this.OrderStatus.Value = fields[5];
            if (fields.Count > 6) this.ResponseFlag.Value = fields[6];
            if (fields.Count > 7) this.QuantityTiming.Value = fields[7];
            if (fields.Count > 8) this.Parent.Value = fields[8];
            if (fields.Count > 9) this.DateTimeOfTransaction.Value = fields[9];
            if(fields.Count>10)this.EnteredBy.Value = fields[10];
            if (fields.Count > 11) this.VerifiedBy.Value = fields[11];
            if (fields.Count < 12) { return; }
            if (fields[12].Contains(componentDelimiter) == false) {
                throw new ArgumentException("Missing component delimiter in field 'ORC.13'");
            }
            components = new List<string>(fields[12].Split(new string[] { componentDelimiter }, StringSplitOptions.None));
            //A field can have seperate components, essentially nested fields with a differnt delimiter
            //Currently doesn't handle repeating ~ segments.
            if (components.Count >= 1) { this.OrderingProviderIDNumber.Value = components[0]; }
            if (components.Count >= 2) { this.OrderingProviderLastName.Value = components[1]; }
            if (components.Count >= 3) { this.OrderingProviderFirstInitial.Value = components[2]; }
            if (components.Count >= 4) { this.OrderingProviderMiddleInitial.Value = components[3]; }
            if (components.Count >= 5) { this.OrderingProviderSuffix.Value = components[4]; }
            if (components.Count >= 6) { this.OrderingProviderPrefix.Value = components[5]; }
            if (components.Count >= 7) { this.OrderingProviderDegree.Value = components[6]; }
            if (components.Count >= 8) { this.SourceTable.Value = components[7]; }
            if (components.Count >= 9 && (this.SourceTable.Value == null || this.SourceTable.Value.Trim() == string.Empty)) {
                this.SourceTable.Value = components[8];
            }
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 13) {
                for (int x = 13; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ORC." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public CommonOrderSegment(string fieldDelimiter, string componentDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field commonOrder in KnownFields) {
                commonOrder.Delimiter = fieldDelimiter;
            }
            //Comonent (nested fields) Delimiters
            foreach (Field commonOrder in new Field[] { UniqueForeignAccessionOrSpecimenID, OrderingProviderIDNumber, OrderingProviderLastName, OrderingProviderFirstInitial, OrderingProviderMiddleInitial, OrderingProviderSuffix, OrderingProviderPrefix, OrderingProviderDegree }) {
                commonOrder.Delimiter = componentDelimiter;
            }
            //Last field is always a newline
            SourceTable.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
