using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class BloodLeadSegment : Segment {
        #region Private Instance Variables
        private Field _PatientRace = new Field();
        private Field _Hispanic = new Field();
        private Field _BloodLeadType = new Field();
        private Field _BloodLeadPurpose = new Field();
        private Field _BloodLeadCountyCodeNumber = new Field();
        #endregion
        #region Public Instance Properties
        public Field PatientRace {
            get {
                return _PatientRace;
            }
            private set {
                _PatientRace = value;
            }
        }
        public Field Hispanic {
            get {
                return _Hispanic;
            }
            private set {
                _Hispanic = value;
            }
        }
        public Field BloodLeadType {
            get {
                return _BloodLeadType;
            }
            private set {
                _BloodLeadType = value;
            }
        }
        public Field BloodLeadPurpose {
            get {
                return _BloodLeadPurpose;
            }
            private set {
                _BloodLeadPurpose = value;
            }
        }
        public Field BloodLeadCountyCodeNumber {
            get {
                return _BloodLeadCountyCodeNumber;
            }
            private set {
                _BloodLeadCountyCodeNumber = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, PatientRace, Hispanic, BloodLeadType, BloodLeadPurpose, BloodLeadCountyCodeNumber });
            }
        }
        public override string SegmentType {
            get {
                return "ZBL";
            }
        }
        public override string Title {
            get {
                return "Blood Lead";
            }
        }
        #endregion
        #region Constructors
        public BloodLeadSegment() {
            this.SegmentTypeID = new Field("Segment Type ID", "ZBL.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "ZBL");
            this.PatientRace = new Field("Patient Race", "ZBL.2", "Race is required for blood lead testing procedures", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.Hispanic = new Field("Hispanic", "ZBL.3", "This field is self-identification rather than scientific classification", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            this.BloodLeadType = new Field("Blood Lead Type", "ZBL.4", "Indication of how specimen was collected", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.BloodLeadPurpose = new Field("Blood Lead Purpose", "ZBL.5", "Indication of reason for testing", RequiredFlags.Optional, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            this.BloodLeadCountyCodeNumber = new Field("BloodLeadCountyCodeNumber", "ZBL.6", "For state reporting of blood lead results", RequiredFlags.Conditional, 10, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
        }
        public BloodLeadSegment(string fieldDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field diagnosis in KnownFields) {
                diagnosis.Delimiter = fieldDelimiter;
            }
            //Last one is always a newline
            this.BloodLeadCountyCodeNumber.Delimiter = System.Environment.NewLine;
        }
        public BloodLeadSegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 6) {
                throw new ArgumentException("Not enough fields to construct a valid patient general clinical information segment (ZBL).  Expected at least 6, returned " + fields.Count);
            }
            this.SegmentTypeID.Value = fields[0];
            this.PatientRace.Value = fields[1];
            this.Hispanic.Value = fields[2];
            this.BloodLeadType.Value = fields[3];
            this.BloodLeadPurpose.Value = fields[4];
            this.BloodLeadCountyCodeNumber.Value = fields[5];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 6) {
                for (int x = 6; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZBL." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        #endregion
    }
}
