using System;
using System.Collections.Generic;
using System.Text;

namespace HL7 {
    public class BethesdaCytologySegment : Segment {
        #region Private Instance Variables
        private Field _Cervical = new Field();
        private Field _Endocervical = new Field();
        private Field _LabiaVulva = new Field();
        private Field _Vaginal = new Field();
        private Field _Endometrial = new Field();
        private Field _SwabSpatula = new Field();
        private Field _BrushSpatula = new Field();
        private Field _SpatulaAlone = new Field();
        private Field _BrushAlone = new Field();
        private Field _BroomAlone = new Field();
        private Field _OtherCollectionTechnique = new Field();
        private Field _LMPMenoDate = new Field();
        private Field _None = new Field();
        private Field _Hyst = new Field();
        private Field _Coniza = new Field();
        private Field _ColpBX = new Field();
        private Field _LaserVap = new Field();
        private Field _Cyro = new Field();
        private Field _Radiation = new Field();
        private Field _DatesResults = new Field();
        private Field _Pregnant = new Field();
        private Field _Lactating = new Field();
        private Field _OralContraceptives = new Field();
        private Field _Menopausal = new Field();
        private Field _EstroRX = new Field();
        private Field _PMPBleeding = new Field();
        private Field _PostPart = new Field();
        private Field _IUD = new Field();
        private Field _AllOtherPat = new Field();
        private Field _Negative = new Field();
        private Field _Atypical = new Field();
        private Field _Dysplasia = new Field();
        private Field _CaInSitu = new Field();
        private Field _Invasive = new Field();
        private Field _OtherPreviousInformation = new Field();
        private Field _HysterectomySupracervical = new Field();
        #endregion
        #region Public Instance Properties
        public Field Cervical {
            get {
                return _Cervical;
            }
            private set {
                _Cervical = value;
            }
        }
        public Field Endocervical {
            get {
                return _Endocervical;
            }
            private set {
                _Endocervical = value;
            }
        }
        public Field LabiaVulva {
            get {
                return _LabiaVulva;
            }
            private set {
                _LabiaVulva = value;
            }
        }
        public Field Vaginal {
            get {
                return _Vaginal;
            }
            private set {
                _Vaginal = value;
            }
        }
        public Field Endometrial {
            get {
                return _Endometrial;
            }
            private set {
                _Endometrial = value;
            }
        }
        public Field SwabSpatula {
            get {
                return _SwabSpatula;
            }
            private set {
                _SwabSpatula = value;
            }
        }
        public Field BrushSpatula {
            get {
                return _BrushSpatula;
            }
            private set {
                _BrushSpatula = value;
            }
        }
        public Field SpatulaAlone {
            get {
                return _SpatulaAlone;
            }
            private set {
                _SpatulaAlone = value;
            }
        }
        public Field BrushAlone {
            get {
                return _BrushAlone;
            }
            private set {
                _BrushAlone = value;
            }
        }
        public Field BroomAlone {
            get {
                return _BroomAlone;
            }
            private set {
                _BroomAlone = value;
            }
        }
        public Field OtherCollectionTechnique {
            get {
                return _OtherCollectionTechnique;
            }
            private set {
                _OtherCollectionTechnique = value;
            }
        }
        public Field LMPMenoDate {
            get {
                return _LMPMenoDate;
            }
            private set {
                _LMPMenoDate = value;
            }
        }
        public Field None {
            get {
                return _None;
            }
            private set {
                _None = value;
            }
        }
        public Field Hyst {
            get {
                return _Hyst;
            }
            private set {
                _Hyst = value;
            }
        }
        public Field Coniza {
            get {
                return _Coniza;
            }
            private set {
                _Coniza = value;
            }
        }
        public Field ColpBX {
            get {
                return _ColpBX;
            }
            private set {
                _ColpBX = value;
            }
        }
        public Field LaserVap {
            get {
                return _LaserVap;
            }
            private set {
                _LaserVap = value;
            }
        }
        public Field Cyro {
            get {
                return _Cyro;
            }
            private set {
                _Cyro = value;
            }
        }
        public Field Radiation {
            get {
                return _Radiation;
            }
            private set {
                _Radiation = value;
            }
        }
        public Field DatesResults {
            get {
                return _DatesResults;
            }
            private set {
                _DatesResults = value;
            }
        }
        public Field Pregnant {
            get {
                return _Pregnant;
            }
            private set {
                _Pregnant = value;
            }
        }
        public Field Lactating {
            get {
                return _Lactating;
            }
            private set {
                _Lactating = value;
            }
        }
        public Field OralContraceptives {
            get {
                return _OralContraceptives;
            }
            private set {
                _OralContraceptives = value;
            }
        }
        public Field Menopausal {
            get {
                return _Menopausal;
            }
            private set {
                _Menopausal = value;
            }
        }
        public Field EstroRX {
            get {
                return _EstroRX;
            }
            private set {
                _EstroRX = value;
            }
        }
        public Field PMPBleeding {
            get {
                return _PMPBleeding;
            }
            private set {
                _PMPBleeding = value;
            }
        }
        public Field PostPart {
            get {
                return _PostPart;
            }
            private set {
                _PostPart = value;
            }
        }
        public Field IUD {
            get {
                return _IUD;
            }
            private set {
                _IUD = value;
            }
        }
        public Field AllOtherPat {
            get {
                return _AllOtherPat;
            }
            private set {
                _AllOtherPat = value;
            }
        }
        public Field Negative {
            get {
                return _Negative;
            }
            private set {
                _Negative = value;
            }
        }
        public Field Atypical {
            get {
                return _Atypical;
            }
            private set {
                _Atypical = value;
            }
        }
        public Field Dysplasia {
            get {
                return _Dysplasia;
            }
            private set {
                _Dysplasia = value;
            }
        }
        public Field CaInSitu {
            get {
                return _CaInSitu;
            }
            private set {
                _CaInSitu = value;
            }
        }
        public Field Invasive {
            get {
                return _Invasive;
            }
            private set {
                _Invasive = value;
            }
        }
        public Field OtherPreviousInformation {
            get {
                return _OtherPreviousInformation;
            }
            private set {
                _OtherPreviousInformation = value;
            }
        }
        public Field HysterectomySupracervical {
            get {
                return _HysterectomySupracervical;
            }
            private set {
                _HysterectomySupracervical = value;
            }
        }
        public override List<Field> KnownFields {
            get {
                return new List<Field>(new Field[] { SegmentTypeID, Cervical, Endocervical, LabiaVulva, Vaginal, Endometrial, SwabSpatula, BrushSpatula, SpatulaAlone, BrushAlone, BroomAlone, OtherCollectionTechnique, LMPMenoDate, None, Hyst, Coniza, ColpBX, LaserVap, Cyro, Radiation, DatesResults, Pregnant, Lactating, OralContraceptives, Menopausal, EstroRX, PMPBleeding, PostPart, IUD, AllOtherPat, Negative, Atypical, Dysplasia, CaInSitu, Invasive, OtherPreviousInformation, HysterectomySupracervical });
            }
        }
        public override string SegmentType {
            get {
                return "ZCY";
            }
        }
        public override string Title {
            get {
                return "Bethesda Cytology";
            }
        }
        #endregion
        #region Constructors
        public BethesdaCytologySegment() {
            SegmentTypeID = new Field("Segment Type ID", "ZCY.1", "To identify the segment", RequiredFlags.AlwaysRequired, 3, string.Empty, SupportedCharacters.AlphaOnly, 0, "ZCY");
            Cervical = new Field("Cervical", "ZCY.2", "Gynecological source", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Endocervical = new Field("Endocervical", "ZCY.3", "Gynecological source", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            LabiaVulva = new Field("Labia-Vulva", "ZCY.4", "Gynecological source", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Vaginal = new Field("Vaginal", "ZCY.5", "Gynecological source", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Endometrial = new Field("Endometrial", "ZCY.6", "Gynecological source", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            SwabSpatula = new Field("Swab-Spatula", "ZCY.7", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            BrushSpatula = new Field("Brush-Spatula", "ZCY.8", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            SpatulaAlone = new Field("Spatula-Alone", "ZCY.9", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            BrushAlone = new Field("Brush-Alone", "ZCY.10", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            BroomAlone = new Field("Broom-Alone", "ZCY.11", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            OtherCollectionTechnique = new Field("Other collection technique", "ZCY.12", "Collection technique", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            LMPMenoDate = new Field("LMP-Meno Date", "ZCY.13", "Date of patient's last menstrual period or menopausal date", RequiredFlags.AlwaysRequired, 8, string.Empty, SupportedCharacters.NumericOnly, 0, string.Empty);
            None = new Field("None", "ZCY.14", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Hyst = new Field("Hyst", "ZCY.15", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Coniza = new Field("Coniza", "ZCY.16", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            ColpBX = new Field("Colp-BX", "ZCY.17", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            LaserVap = new Field("Laser-Vap", "ZCY.18", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Cyro = new Field("Cyro", "ZCY.19", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Radiation = new Field("Radiation", "ZCY.20", "Previous treatment", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            DatesResults = new Field("Dates-Results", "ZCY.21", "Previous cytology information", RequiredFlags.AlwaysRequired, 25, string.Empty, SupportedCharacters.AlphaNumericSpecial, 0, string.Empty);
            Pregnant = new Field("Pregnant", "ZCY.22", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Lactating = new Field("Lactating", "ZCY.23", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            OralContraceptives = new Field("Oral Contraceptives", "ZCY.24", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Menopausal = new Field("Menopausal", "ZCY.25", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            EstroRX = new Field("Estro-RX", "ZCY.26", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            PMPBleeding = new Field("PMP-Bleeding", "ZCY.27", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            PostPart = new Field("Post-Part", "ZCY.28", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            IUD = new Field("IUD", "ZCY.29", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            AllOtherPat = new Field("All-Other-Pat", "ZCY.30", "Other patient information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Negative = new Field("Negative", "ZCY.31", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Atypical = new Field("Atypical", "ZCY.32", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Dysplasia = new Field("Dysplasia", "ZCY.33", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            CaInSitu = new Field("Ca-In-Situ", "ZCY.34", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            Invasive = new Field("Invasive", "ZCY.35", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            OtherPreviousInformation = new Field("Other Previous Information", "ZCY.36", " Previous cytology information", RequiredFlags.AlwaysRequired, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
            HysterectomySupracervical = new Field("", "ZCY.37", "", RequiredFlags.Optional, 1, string.Empty, SupportedCharacters.AlphaOnly, 0, string.Empty);
        }
        public BethesdaCytologySegment(string message, string fieldDelimiter)
            : this(fieldDelimiter) {
            List<string> fields = new List<string>(message.Split(new string[] { fieldDelimiter }, StringSplitOptions.None));
            if (fields.Count < 36) {
                throw new ArgumentException("Not enough fields to construct a valid bethesda cytology segment (ZCY).  Expected at least 36, returned " + fields.Count);
            }
            SegmentTypeID.Value = fields[0];
            Cervical.Value = fields[1];
            Endocervical.Value = fields[2];
            LabiaVulva.Value = fields[3];
            Vaginal.Value = fields[4];
            Endometrial.Value = fields[5];
            SwabSpatula.Value = fields[6];
            BrushSpatula.Value = fields[7];
            SpatulaAlone.Value = fields[8];
            BrushAlone.Value = fields[9];
            BroomAlone.Value = fields[10];
            OtherCollectionTechnique.Value = fields[11];
            LMPMenoDate.Value = fields[12];
            None.Value = fields[13];
            Hyst.Value = fields[14];
            Coniza.Value = fields[15];
            ColpBX.Value = fields[16];
            LaserVap.Value = fields[17];
            Cyro.Value = fields[18];
            Radiation.Value = fields[19];
            DatesResults.Value = fields[20];
            Pregnant.Value = fields[21];
            Lactating.Value = fields[22];
            OralContraceptives.Value = fields[23];
            Menopausal.Value = fields[24];
            EstroRX.Value = fields[25];
            PMPBleeding.Value = fields[26];
            PostPart.Value = fields[27];
            IUD.Value = fields[28];
            AllOtherPat.Value = fields[29];
            Negative.Value = fields[30];
            Atypical.Value = fields[31];
            Dysplasia.Value = fields[32];
            CaInSitu.Value = fields[33];
            Invasive.Value = fields[34];
            OtherPreviousInformation.Value = fields[35];
            HysterectomySupracervical.Value = fields[36];
            //Any additional segments that we don't know about
            //Doesn't handle nested segments
            if (fields.Count > 37) {
                for (int x = 37; x < fields.Count - 1; x++) {
                    Field newField = new Field("Additional unknown field", "ZCY." + x, "Unknown", RequiredFlags.Unknown, -1, fieldDelimiter, SupportedCharacters.Unknown, -1, fields[x]);
                    AdditionalFields.Add(newField);
                }
            }
        }
        public BethesdaCytologySegment(string fieldDelimiter)
            : this() {
            //Field Delimiters
            foreach (Field bethesdaCytology in KnownFields) {
                bethesdaCytology.Delimiter = fieldDelimiter;
            }
            //Last one is always a newline
            this.OtherPreviousInformation.Delimiter = System.Environment.NewLine;
        }
        #endregion
    }
}
